/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaFactory {
    private PropertyMapBuilder properties = new PropertyMapBuilder();
    private boolean compactSyntax = false;
    private SchemaReader autoSchemaLanguage = new AutoSchemaReader();

    public Schema createSchema(InputSource in) throws IOException, SAXException, IncorrectSchemaException {
        SchemaReader r = this.compactSyntax ? CompactSchemaReader.getInstance() : this.autoSchemaLanguage;
        return r.createSchema(in, this.properties.toPropertyMap());
    }

    public void setXMLReaderCreator(XMLReaderCreator xrc) {
        this.properties.put(ValidateProperty.XML_READER_CREATOR, xrc);
    }

    public XMLReaderCreator getXMLReaderCreator() {
        return (XMLReaderCreator)this.properties.get(ValidateProperty.XML_READER_CREATOR);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.properties.put(ValidateProperty.ERROR_HANDLER, eh);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.properties.get(ValidateProperty.ERROR_HANDLER);
    }

    public void setDatatypeLibraryFactory(DatatypeLibraryFactory dlf) {
        this.properties.put(RngProperty.DATATYPE_LIBRARY_FACTORY, dlf);
    }

    public DatatypeLibraryFactory getDatatypeLibraryFactory() {
        return (DatatypeLibraryFactory)this.properties.get(RngProperty.DATATYPE_LIBRARY_FACTORY);
    }

    public void setCheckIdIdref(boolean checkIdIdref) {
        this.properties.put(RngProperty.CHECK_ID_IDREF, checkIdIdref ? Flag.PRESENT : null);
    }

    public boolean getCheckIdIdref() {
        return this.properties.contains(RngProperty.CHECK_ID_IDREF);
    }

    public void setCompactSyntax(boolean compactSyntax) {
        this.compactSyntax = compactSyntax;
    }

    public boolean getCompactSyntax() {
        return this.compactSyntax;
    }

    public void setFeasible(boolean feasible) {
        this.properties.put(RngProperty.FEASIBLE, feasible ? Flag.PRESENT : null);
    }

    public boolean getFeasible() {
        return this.properties.contains(RngProperty.FEASIBLE);
    }
}

