/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

public class ELPreprocessor {
    public static final String[][] XML_ENTITY_REFS_CONVERSION_TABLE = new String[][]{{"&amp;", "&"}, {"&gt;", ">"}, {"&lt;", "<"}, {"&quot;", "\""}, {"&apos;", "'"}};
    public static String[][] ESCAPED_CHARACTERS = new String[][]{{"\\\\", "\\"}, {"\\<", "<"}, {"\\>", ">"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\&", "&"}};
    private final String originalExpression;
    private final String[][][] conversionTables;
    private String preprocessedExpression;
    private final boolean[] diffs;

    public ELPreprocessor(String expression, String[][] ... conversionTables) {
        this.originalExpression = expression;
        this.conversionTables = conversionTables;
        this.diffs = new boolean[this.originalExpression.length()];
        this.init();
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public String getPreprocessedExpression() {
        return this.preprocessedExpression;
    }

    public int getOriginalOffset(int preprocessedELoffset) {
        int diff = 0;
        for (int i = 0; i < this.originalExpression.length(); ++i) {
            int pointer = i + diff;
            if (pointer == preprocessedELoffset) {
                return i;
            }
            diff += this.diffs[i] ? -1 : 0;
        }
        assert (preprocessedELoffset == this.preprocessedExpression.length());
        return this.originalExpression.length();
    }

    public int getPreprocessedOffset(int originalOffset) {
        int diff = 0;
        for (int i = 0; i < originalOffset; ++i) {
            diff += this.diffs[i] ? -1 : 0;
        }
        return originalOffset + diff;
    }

    private void init() {
        boolean[] localDiffs = new boolean[this.diffs.length];
        String result = this.originalExpression;
        String[][][] arr$ = this.conversionTables;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[][] table;
            for (String[] patternPair : table = arr$[i$]) {
                int match;
                System.arraycopy(this.diffs, 0, localDiffs, 0, this.diffs.length);
                StringBuilder resolved = new StringBuilder();
                String source = patternPair[0];
                String dest = patternPair[1];
                assert (source.length() >= dest.length()) : "no expanding rules supported!";
                int lastMatchEnd = 0;
                while ((match = result.indexOf(source, lastMatchEnd)) != -1) {
                    resolved.append(result.substring(lastMatchEnd, match));
                    resolved.append(dest);
                    int originalSourceMatch = this.getOriginalOffset(match);
                    int patternsLenDiff = source.length() - dest.length();
                    for (int i = originalSourceMatch; i < originalSourceMatch + patternsLenDiff; ++i) {
                        localDiffs[i] = true;
                    }
                    lastMatchEnd = match + source.length();
                }
                resolved.append(result.substring(lastMatchEnd));
                result = resolved.toString();
                System.arraycopy(localDiffs, 0, this.diffs, 0, this.diffs.length);
            }
        }
        this.preprocessedExpression = result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ELPreprocessor.class.getSimpleName());
        sb.append('(');
        sb.append(System.identityHashCode(this));
        sb.append(')');
        sb.append('\n');
        for (String[][] table : this.conversionTables) {
            sb.append("table:");
            for (String[] pattern : table) {
                sb.append('(');
                sb.append(pattern[0]);
                sb.append("->");
                sb.append(pattern[1]);
                sb.append(')');
            }
            sb.append(' ');
        }
        sb.append('\n');
        sb.append("source:");
        sb.append(this.getOriginalExpression());
        sb.append("\n");
        sb.append("diffs :");
        for (int i = 0; i < this.diffs.length; ++i) {
            sb.append(this.diffs[i] ? "-" : "0");
        }
        sb.append("\n");
        sb.append("result:");
        sb.append(this.getPreprocessedExpression());
        sb.append("\n");
        return sb.toString();
    }
}

