/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ConvertPanel
extends JPanel
implements ActionListener,
Runnable,
DocumentListener {
    private DialogDescriptor descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(ConvertPanel.class, (String)"TITLE_ConvertPanel"));
    private JButton startButton = new JButton(NbBundle.getMessage(ConvertPanel.class, (String)"DISP_Start"));
    private JButton finishButton = new JButton(NbBundle.getMessage(ConvertPanel.class, (String)"DISP_Close"));
    private FileObject inputPrimaryFile;
    private FileObject inputSecondaryFile;
    private FileObject outputDirectory;
    private JLabel finishIcon;
    private JLabel finishMessage;
    private JTextField inputFileName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel message;
    private JTextField outputFileName;
    private JProgressBar progress;

    public ConvertPanel() {
        this.initComponents();
        ImageIcon warningMessage = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/warning.gif", (boolean)false);
        this.finishIcon.setIcon(warningMessage);
        this.message.setIcon(warningMessage);
        this.startButton.setDefaultCapable(true);
        this.startButton.addActionListener(this);
        this.finishButton.setDefaultCapable(true);
        this.descriptor.setClosingOptions(new Object[]{this.finishButton, DialogDescriptor.CANCEL_OPTION});
    }

    public DialogDescriptor getDialogDescriptor() {
        return this.descriptor;
    }

    public void switchToShown(FileObject inputPrimaryFile, FileObject inputSecondaryFile, FileObject outputDirectory) {
        this.inputPrimaryFile = inputPrimaryFile;
        this.inputSecondaryFile = inputSecondaryFile;
        this.outputDirectory = outputDirectory;
        this.inputFileName.setText(inputPrimaryFile.getName());
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(false);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_ShownMessage"));
        this.startButton.setEnabled(true);
        this.descriptor.setOptions(new Object[]{this.startButton, DialogDescriptor.CANCEL_OPTION});
        this.outputFileName.getDocument().removeDocumentListener(this);
        this.outputFileName.getDocument().addDocumentListener(this);
        this.outputFileName.setText("Converted" + inputPrimaryFile.getName());
        this.outputFileName.setEditable(true);
        this.outputFileName.selectAll();
        this.outputFileName.requestFocus();
    }

    public void switchToStarted() {
        this.outputFileName.getDocument().removeDocumentListener(this);
        this.outputFileName.setEditable(false);
        this.progress.setIndeterminate(true);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_StartMessage"));
        this.startButton.setEnabled(false);
        this.descriptor.setOptions(new Object[0]);
    }

    public void switchToFinished() {
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(true);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_FinishMessage"));
        this.descriptor.setOptions(new Object[]{this.finishButton});
    }

    public void switchToErrors(ArrayList<String> errors) {
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(true);
        StringBuffer str = new StringBuffer();
        for (String string : errors) {
            str.append(string);
            str.append('\n');
        }
        this.finishMessage.setText(str.toString());
        this.descriptor.setOptions(new Object[]{this.finishButton});
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkErrors();
    }

    private void checkErrors() {
        boolean exists = this.outputDirectory.getFileObject(this.outputFileName.getText(), "java") != null || this.outputDirectory.getFileObject(this.outputFileName.getText(), "vmd") != null;
        this.message.setVisible(exists);
        this.startButton.setEnabled(!exists);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.inputFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.outputFileName = new JTextField();
        JSeparator jSeparator1 = new JSeparator();
        this.progress = new JProgressBar();
        this.finishMessage = new JLabel();
        this.finishIcon = new JLabel();
        this.message = new JLabel();
        this.setPreferredSize(new Dimension(500, 400));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/converter/wizard/Bundle").getString("ConvertPanel.jLabel1.mnemonic").charAt(0));
        this.jLabel2.setLabelFor(this.inputFileName);
        this.jLabel2.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel2.text"));
        this.inputFileName.setEditable(false);
        this.inputFileName.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.inputFileName.text"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/converter/wizard/Bundle").getString("ConvertPanel.jLabel2.mnemonic").charAt(0));
        this.jLabel1.setLabelFor(this.outputFileName);
        this.jLabel1.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel1.text"));
        this.outputFileName.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.outputFileName.text"));
        this.finishMessage.setVerticalAlignment(1);
        this.finishIcon.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.finishIcon.text"));
        this.finishIcon.setPreferredSize(new Dimension(16, 16));
        this.message.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.message.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.finishIcon, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishMessage, -1, 458, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 127, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputFileName, -1, 341, Short.MAX_VALUE).addComponent(this.inputFileName, -1, 341, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(jSeparator1, -1, 480, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.progress, -1, 480, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.message, -2, 480, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.inputFileName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.outputFileName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.finishIcon, -2, -1, -2).addComponent(this.finishMessage, -1, 269, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.message).addContainerGap()));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel2.AccessibleContext.accessibleDescription"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConvertPanel.class, (String)"ACC_NAME_ConvertPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ACC_DESC_ConvertPanel"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.switchToStarted();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        final ArrayList<String> errors = new ArrayList<String>();
        try {
            ArrayList<String> _errors = Converter.convert(this.inputPrimaryFile, this.inputSecondaryFile, this.outputFileName.getText());
            if (!_errors.isEmpty()) {
                errors.addAll(_errors);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (errors.isEmpty()) {
                    ConvertPanel.this.switchToFinished();
                } else {
                    ConvertPanel.this.switchToErrors(errors);
                }
            }
        });
    }
}

