/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.vmd.api.codegen.JavaCodeGenerator;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.listeners.CommandListenerCD;
import org.netbeans.modules.vmd.midp.components.listeners.ItemCommandListenerCD;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class ConverterCode {
    static void convertCode(List<ConverterItem> items, StyledDocument styledDocument, final StyledDocument outputStyledDocument, DesignDocument document, String oldDesignName, String newDesignName) throws BadLocationException {
        int i;
        HashMap<String, String> replaceTable = ConverterCode.createUserCodeConvertTable(items);
        replaceTable.put(oldDesignName, newDesignName);
        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        final StringBuffer globalCode = new StringBuffer();
        String getDisplayMethodBody = "";
        String exitMIDletMethodBody = "";
        String getDisplayBeforeCode = null;
        String exitMIDletBeforeCode = null;
        for (GuardedSection section : manager.getGuardedSections()) {
            DesignComponent listener;
            if ("MVDFields".equals(section.getName())) {
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if ("MVDMethods".equals(section.getName())) {
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if ("MVDInitBegin".equals(section.getName())) {
                long rootID = document.getRootComponent().getComponentID();
                ConverterCode.putUserCode(outputStyledDocument, rootID + "-initialize", rootID + "-preInitialize", replaceTable, ConverterCode.getUserCodeAfterSection(styledDocument, section));
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if ("MVDInitEnd".equals(section.getName())) {
                long rootID = document.getRootComponent().getComponentID();
                ConverterCode.putUserCode(outputStyledDocument, rootID + "-initialize", rootID + "-postInitialize", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if ("MVDGetDisplay".equals(section.getName())) {
                getDisplayBeforeCode = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                InteriorSection is = (InteriorSection)section;
                getDisplayMethodBody = is.getBody();
                continue;
            }
            if ("MVDExitMidlet".equals(section.getName())) {
                exitMIDletBeforeCode = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                InteriorSection is = (InteriorSection)section;
                exitMIDletMethodBody = is.getBody();
                continue;
            }
            if (section.getName().startsWith("MVDGetBegin")) {
                ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDGetBegin".length()));
                long id = item.getRelatedComponent().getComponentID();
                ConverterCode.putUserCode(outputStyledDocument, id + "-getter", id + "-preInit", replaceTable, ConverterCode.getUserCodeAfterSection(styledDocument, section));
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if (section.getName().startsWith("MVDGetEnd")) {
                ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDGetEnd".length()));
                long id = item.getRelatedComponent().getComponentID();
                ConverterCode.putUserCode(outputStyledDocument, id + "-getter", id + "-postInit", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (section.getName().startsWith("MVDCABegin")) {
                DesignComponent listener2 = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)CommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener2.getComponentID() + "-commandAction", listener2.getComponentID() + "-preCommandAction", replaceTable, ConverterCode.getUserCodeAfterSection(styledDocument, section));
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if (section.getName().startsWith("MVDCAEnd")) {
                DesignComponent listener3 = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)CommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener3.getComponentID() + "-commandAction", listener3.getComponentID() + "-postCommandAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (section.getName().startsWith("MVDCAAction")) {
                ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDCAAction".length()));
                long id = item.getRelatedComponent().getComponentID();
                listener = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)CommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener.getComponentID() + "-commandAction", id + "-preAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (section.getName().startsWith("MVDCACase")) {
                ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDCACase".length()));
                long id = item.getRelatedComponent().getComponentID();
                listener = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)CommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener.getComponentID() + "-commandAction", id + "-postAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (section.getName().startsWith("MVDICABegin")) {
                DesignComponent listener4 = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)ItemCommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener4.getComponentID() + "-itemCommandAction", listener4.getComponentID() + "-preItemCommandAction", replaceTable, ConverterCode.getUserCodeAfterSection(styledDocument, section));
                String before = ConverterCode.getUserCodeBeforeSection(styledDocument, section);
                if (before == null) continue;
                globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, before)).append('\n');
                continue;
            }
            if (section.getName().startsWith("MVDICAEnd")) {
                DesignComponent listener5 = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)ItemCommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener5.getComponentID() + "-itemCommandAction", listener5.getComponentID() + "-postItemCommandAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (section.getName().startsWith("MVDICAAction")) {
                ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDICAAction".length()));
                long id = item.getRelatedComponent().getComponentID();
                listener = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)ItemCommandListenerCD.TYPEID);
                ConverterCode.putUserCode(outputStyledDocument, listener.getComponentID() + "-itemCommandAction", id + "-preAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
                continue;
            }
            if (!section.getName().startsWith("MVDICACase")) continue;
            ConverterItem item = ConverterCode.findItemWithUID(items, section.getName().substring("MVDICACase".length()));
            long id = item.getRelatedComponent().getComponentID();
            listener = MidpDocumentSupport.getCommandListener((DesignDocument)document, (TypeID)ItemCommandListenerCD.TYPEID);
            ConverterCode.putUserCode(outputStyledDocument, listener.getComponentID() + "-itemCommandAction", id + "-postAction", replaceTable, ConverterCode.getUserCodeBeforeSection(styledDocument, section));
        }
        if (getDisplayBeforeCode != null) {
            globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, getDisplayBeforeCode)).append('\n');
        }
        getDisplayMethodBody = getDisplayMethodBody + "\n        // return Display.getDisplay (this);\n";
        globalCode.append("    /**\n     * Returns a display instance.\n     * @return the display instance.\n     */\n");
        globalCode.append("public Display getDisplay () {\n").append(ConverterCode.processUserCodeByTable(replaceTable, getDisplayMethodBody)).append("}\n");
        globalCode.append('\n');
        if (exitMIDletBeforeCode != null) {
            globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, exitMIDletBeforeCode)).append('\n');
        }
        exitMIDletMethodBody = exitMIDletMethodBody + "\n        // switchDisplayable (null, null);\n        // destroyApp(true);\n        // notifyDestroyed();\n";
        globalCode.append("    /**\n     * Exits MIDlet.\n     */\n");
        globalCode.append("public void exitMIDlet() {\n").append(ConverterCode.processUserCodeByTable(replaceTable, exitMIDletMethodBody)).append("}\n");
        globalCode.append('\n');
        int[] indices = new int[]{-1, -1};
        ConverterCode.findIndices(styledDocument, indices);
        if (indices[0] >= 0 && (i = ConverterCode.getFirstGuardedSectionOffset(styledDocument)) != Integer.MAX_VALUE && indices[0] < i) {
            globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, styledDocument.getText(indices[0], i - indices[0])));
            globalCode.append('\n');
        }
        if (indices[1] >= 0 && (i = ConverterCode.getLastGuardedSectionOffset(styledDocument)) != Integer.MIN_VALUE && i < indices[1]) {
            globalCode.append(ConverterCode.processUserCodeByTable(replaceTable, styledDocument.getText(i, indices[1] - i)));
            globalCode.append('\n');
        }
        NbDocument.runAtomic((StyledDocument)outputStyledDocument, (Runnable)new Runnable(){

            @Override
            public void run() {
                int outputOffset = ConverterCode.getLastGuardedSectionOffset(outputStyledDocument);
                assert (outputOffset != Integer.MIN_VALUE);
                try {
                    outputStyledDocument.insertString(outputOffset, globalCode.toString(), null);
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private static void findIndices(StyledDocument styledDocument, final int[] indices) {
        JavaSource source = JavaSource.forDocument((Document)styledDocument);
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree mainClass = ConverterCode.findMainClass(controller);
                    if (mainClass == null) {
                        return;
                    }
                    int start = (int)controller.getTrees().getSourcePositions().getStartPosition(controller.getCompilationUnit(), mainClass);
                    int end = (int)controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), mainClass);
                    if (start < 0 || end < 0 || start >= end) {
                        return;
                    }
                    int bracket = controller.getText().indexOf(123, start);
                    if (bracket < 0 || bracket > end) {
                        return;
                    }
                    if (controller.getText().charAt(end - 1) == '}') {
                        // empty if block
                    }
                    indices[0] = bracket + 1;
                    indices[1] = --end;
                }
            }, true);
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    static ClassTree findMainClass(CompilationController controller) {
        for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
            ClassTree ct;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(ct = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
            return ct;
        }
        return null;
    }

    private static int getFirstGuardedSectionOffset(StyledDocument styledDocument) {
        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        int offset = Integer.MAX_VALUE;
        for (GuardedSection section : manager.getGuardedSections()) {
            offset = Math.min(offset, section.getStartPosition().getOffset());
        }
        return offset;
    }

    private static int getLastGuardedSectionOffset(StyledDocument styledDocument) {
        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        int offset = Integer.MIN_VALUE;
        for (GuardedSection section : manager.getGuardedSections()) {
            offset = Math.max(offset, section.getEndPosition().getOffset() + 1);
        }
        return offset;
    }

    private static String getUserCodeBeforeSection(StyledDocument styledDocument, GuardedSection section) throws BadLocationException {
        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        int offset = section.getStartPosition().getOffset();
        GuardedSection best = null;
        int bestOffset = 0;
        for (GuardedSection s : manager.getGuardedSections()) {
            int o = s.getStartPosition().getOffset();
            if (offset <= o || best != null && bestOffset >= o) continue;
            best = s;
            bestOffset = o;
        }
        if (best == null) {
            return null;
        }
        int start = best.getEndPosition().getOffset() + 1;
        int end = section.getStartPosition().getOffset();
        return styledDocument.getText(start, end - start);
    }

    private static String getUserCodeAfterSection(StyledDocument styledDocument, GuardedSection section) throws BadLocationException {
        GuardedSectionManager manager = GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        int offset = section.getStartPosition().getOffset();
        GuardedSection best = null;
        int bestOffset = 0;
        for (GuardedSection s : manager.getGuardedSections()) {
            int o = s.getStartPosition().getOffset();
            if (o <= offset || best != null && o >= bestOffset) continue;
            best = s;
            bestOffset = o;
        }
        if (best == null) {
            return null;
        }
        int start = section.getEndPosition().getOffset() + 1;
        int end = best.getStartPosition().getOffset();
        return styledDocument.getText(start, end - start);
    }

    private static ConverterItem findItemWithUID(List<ConverterItem> items, String itemUID) {
        for (ConverterItem item : items) {
            if (!item.getUID().equals(itemUID)) continue;
            return item;
        }
        return null;
    }

    private static void putUserCode(StyledDocument styledDocument, String guardedID, String editableID, HashMap<String, String> replaceTable, String userCode) {
        userCode = ConverterCode.processUserCodeByTable(replaceTable, userCode);
        JavaCodeGenerator.getDefault().putUserCode(styledDocument, guardedID, editableID, userCode);
    }

    private static String processUserCodeByTable(HashMap<String, String> replaceTable, String userCode) {
        for (Map.Entry<String, String> entry : replaceTable.entrySet()) {
            String key = entry.getKey();
            int len = key.length();
            if (len < 0) continue;
            int i = 0;
            while ((i = userCode.indexOf(key, i)) >= 0) {
                if (i > 0 && Character.isJavaIdentifierPart(userCode.charAt(i - 1))) {
                    i += len;
                    continue;
                }
                if (i + len < userCode.length() && Character.isJavaIdentifierPart(userCode.charAt(i + len))) {
                    i += len;
                    continue;
                }
                String value = entry.getValue();
                userCode = userCode.substring(0, i) + value + userCode.substring(i + len);
                i += value.length();
            }
        }
        return userCode;
    }

    private static HashMap<String, String> createUserCodeConvertTable(List<ConverterItem> items) {
        HashMap<String, String> table = new HashMap<String, String>();
        for (ConverterItem item : items) {
            if (!item.isClass()) continue;
            String name = item.getID();
            table.put("get_" + name, "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1));
        }
        return table;
    }
}

