/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.registration;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] args) {
        if (args.length <= 0) {
            AutomaticRegistration.printHelpAndExit();
        }
        if ("--add".equals(args[0])) {
            if (args.length < 6) {
                AutomaticRegistration.printHelpAndExit();
            }
            int status = AutomaticRegistration.registerWebLogicInstance(args[1], args[2], args[3], args[4], args[5]);
            System.exit(status);
        } else if ("--remove".equals(args[0])) {
            if (args.length < 4) {
                AutomaticRegistration.printHelpAndExit();
            }
            int status = AutomaticRegistration.unregisterWebLogicInstance(args[1], args[2], args[3]);
            System.exit(status);
        } else if ("--list".equals(args[0])) {
            if (args.length < 2) {
                AutomaticRegistration.printHelpAndExit();
            }
            AutomaticRegistration.list(args[1]);
        } else {
            AutomaticRegistration.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        System.out.println("Available actions:");
        System.out.println("\t--add <clusterDir> <serverDir> <domainDir> <username> <password>");
        System.out.println("\t--remove <clusterDir> <serverDir> <domainDir>");
        System.out.println("\t--list <clusterDir>");
        System.exit(-1);
    }

    private static int registerWebLogicInstance(String clusterDirValue, String serverDirValue, String domainDirValue, String username, String password) {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server. The config/J2EE/InstalledServers folder cannot be created.");
            return 2;
        }
        File serverDir = FileUtil.normalizeFile((File)new File(serverDirValue));
        if (!serverDir.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server. The server directory " + serverDirValue + " does not exist.");
            return 3;
        }
        File domainDir = FileUtil.normalizeFile((File)new File(domainDirValue));
        if (!domainDir.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server. The domain directory " + domainDirValue + " does not exist.");
            return 4;
        }
        Version version = WLPluginProperties.getServerVersion(serverDir);
        if (!WLPluginProperties.isSupportedVersion(version)) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.  The version " + version + " is not supported.");
            return 5;
        }
        Properties properties = WLPluginProperties.getDomainProperties(domainDir.getAbsolutePath());
        if (properties.isEmpty()) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.  The domain " + domainDirValue + " is not valid domain.");
            return 6;
        }
        String name = properties.getProperty("adminName");
        String port = properties.getProperty("port");
        String host = properties.getProperty("host");
        String domainName = properties.getProperty("domainName");
        String versionString = properties.getProperty("domainVersion");
        Version domainVersion = versionString != null ? Version.fromJsr277OrDottedNotationWithFallback((String)versionString) : null;
        Boolean isProductionMode = (Boolean)properties.get("productionMode");
        if (name == null || name.equals("")) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.  The domain name is empty.");
            return 7;
        }
        port = port == null || port.equals("") ? Integer.toString(7001) : port;
        host = host == null || host.equals("") ? "localhost" : host;
        if (isProductionMode != null && isProductionMode.booleanValue()) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.  The domain is in production mode.");
            return 8;
        }
        if (domainVersion != null && version != null && !version.equals((Object)domainVersion)) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.  The domain version does not match the server version.");
            return 9;
        }
        StringBuilder urlTmp = new StringBuilder();
        urlTmp.append("deployer:WebLogic:http://");
        urlTmp.append(host).append(":");
        urlTmp.append(port).append(":");
        urlTmp.append(serverDir.getAbsolutePath()).append(":");
        urlTmp.append(domainDir.getAbsolutePath());
        String url = urlTmp.toString();
        for (FileObject fo : serverInstanceDir.getChildren()) {
            if (!url.equals(fo.getAttribute("url"))) continue;
            return 0;
        }
        String displayName = AutomaticRegistration.generateUniqueDisplayName(serverInstanceDir, version);
        boolean ok = AutomaticRegistration.registerServerInstanceFO(serverInstanceDir, url, displayName, serverDir.getAbsolutePath(), domainDir.getAbsolutePath(), domainName, port, username, password);
        if (ok) {
            return 0;
        }
        return 10;
    }

    private static int unregisterWebLogicInstance(String clusterDirValue, String serverDirValue, String domainDirValue) {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^" + Pattern.quote("deployer:WebLogic:http://") + "(.+):(.+):" + Pattern.quote(serverDirValue) + ":" + Pattern.quote(domainDirValue) + "$");
        try {
            for (FileObject f : serverInstanceDir.getChildren()) {
                String url = f.getAttribute("url").toString();
                if (url == null || !pattern.matcher(url).matches()) continue;
                f.delete();
                return 0;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot unregister the default WebLogic server.");
            LOGGER.log(Level.INFO, null, ex);
            return 6;
        }
        return 0;
    }

    private static int list(String clusterDirValue) {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject serverInstanceDir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (serverInstanceDir == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^" + Pattern.quote("deployer:WebLogic:http://") + "(.+):(.+):(.+):(.+)$");
        for (FileObject f : serverInstanceDir.getChildren()) {
            Matcher matcher;
            String url = f.getAttribute("url").toString();
            if (url == null || !(matcher = pattern.matcher(url)).matches()) continue;
            System.out.println(matcher.group(3) + " " + matcher.group(4));
        }
        return 0;
    }

    private static String generateUniqueDisplayName(FileObject serverInstanceDir, Version version) {
        String displayName = NbBundle.getMessage(WLDeploymentFactory.class, (String)"LBL_OracleWebLogic", (Object)version);
        boolean unique = true;
        int i = 1;
        while (true) {
            for (FileObject fo : serverInstanceDir.getChildren()) {
                if (!displayName.equals(fo.getAttribute("displayName"))) continue;
                unique = false;
                break;
            }
            if (unique) break;
            displayName = NbBundle.getMessage(WLDeploymentFactory.class, (String)"LBL_OracleWebLogicAlt", (Object)version, (Object)i++);
            unique = true;
        }
        return displayName;
    }

    private static boolean registerServerInstanceFO(FileObject serverInstanceDir, String url, String displayName, String serverRoot, String domainRoot, String domainName, String port, String username, String password) {
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"weblogic_autoregistered_instance", null);
        try {
            FileObject instanceFO = serverInstanceDir.createData(name);
            instanceFO.setAttribute("url", (Object)url);
            instanceFO.setAttribute("username", (Object)username);
            instanceFO.setAttribute("password", (Object)password);
            instanceFO.setAttribute("displayName", (Object)displayName);
            instanceFO.setAttribute("httpportnumber", (Object)port);
            instanceFO.setAttribute("serverRoot", (Object)serverRoot);
            instanceFO.setAttribute("domainRoot", (Object)domainRoot);
            instanceFO.setAttribute("debuggerPort", (Object)"8787");
            instanceFO.setAttribute("domainName", (Object)domainName);
            instanceFO.setAttribute("port", (Object)port);
            if (Utilities.isMac()) {
                instanceFO.setAttribute("mem_opts", (Object)"-Xmx1024m -XX:PermSize=256m");
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default WebLogic server.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

