/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderFactory;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class CompletionSupport
implements DocumentListener {
    private final Reference<Document> docRef;
    private static int NOT_INITIALIZED = -1;
    private int lastSeparatorOffset = -1;
    private int contextOffset = NOT_INITIALIZED;

    private CompletionSupport(Document doc) {
        this.docRef = new WeakReference<Document>(doc);
        doc.addDocumentListener(this);
    }

    public static CompletionSupport get(JTextComponent component) {
        return CompletionSupport.get(component.getDocument());
    }

    public static CompletionSupport get(Document doc) {
        CompletionSupport support = (CompletionSupport)doc.getProperty(CompletionSupport.class);
        if (support == null) {
            boolean valid;
            boolean bl = valid = CndLexerUtilities.getLanguage((Document)doc) != null;
            if (valid) {
                support = new CompletionSupport(doc);
                doc.putProperty(CompletionSupport.class, support);
            }
        }
        return support;
    }

    public final Document getDocument() {
        return this.docRef.get();
    }

    public static boolean isPreprocCompletionEnabled(Document doc, int offset) {
        return CompletionSupport.isIncludeCompletionEnabled(doc, offset) || CompletionSupport.isPreprocessorDirectiveCompletionEnabled(doc, offset);
    }

    public static boolean isPreprocessorDirectiveCompletionEnabled(Document doc, int offset) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)false, (boolean)true);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            TokenSequence embedded = ts.embedded();
            embedded.moveStart();
            embedded.moveNext();
            if (!embedded.moveNext()) {
                return true;
            }
            CndTokenUtilities.shiftToNonWhite((TokenSequence)embedded, (boolean)false);
            return embedded.offset() + embedded.token().length() >= offset;
        }
        return false;
    }

    public static boolean isIncludeCompletionEnabled(Document doc, int offset) {
        TokenId id;
        TokenSequence embedded;
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)false, (boolean)true);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE && CndTokenUtilities.moveToPreprocKeyword((TokenSequence)(embedded = ts.embedded())) && (id = embedded.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    return embedded.offset() + embedded.token().length() <= offset;
                }
            }
        }
        return false;
    }

    public final CsmFinder getFinder() {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)this.getDocument());
        assert (dobj != null);
        FileObject fo = dobj.getPrimaryFile();
        return CsmFinderFactory.getDefault().getFinder(fo);
    }

    public void setContextOffset(int offset) {
        this.contextOffset = offset;
    }

    public int doc2context(int docPos) {
        int offset = this.contextOffset == NOT_INITIALIZED ? docPos : this.contextOffset;
        offset = CsmMacroExpansion.getOffsetInOriginalText((Document)this.getDocument(), (int)offset);
        return offset;
    }

    protected void setLastSeparatorOffset(int lastSeparatorOffset) {
        this.lastSeparatorOffset = lastSeparatorOffset;
    }

    protected int getLastCommandSeparator(int pos) throws BadLocationException {
        if (pos < 0 || pos > this.getDocument().getLength()) {
            throw new BadLocationException("position is out of range[0-" + this.getDocument().getLength() + "]", pos);
        }
        if (pos == 0) {
            return 0;
        }
        if (!CndTokenUtilities.isInPreprocessorDirective((Document)this.getDocument(), (int)pos) && !CndTokenUtilities.isInProCDirective((Document)this.getDocument(), (int)pos)) {
            if (this.lastSeparatorOffset >= 0 && this.lastSeparatorOffset < pos && !CndTokenUtilities.isInProCDirective((Document)this.getDocument(), (int)this.lastSeparatorOffset)) {
                return this.lastSeparatorOffset;
            }
            this.lastSeparatorOffset = CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)pos);
            return this.lastSeparatorOffset;
        }
        return CndTokenUtilities.getLastCommandSeparator((Document)this.getDocument(), (int)pos);
    }

    public static CsmClassifier getClassFromName(CsmFinder finder, String className, boolean searchByName) {
        List<CsmClassifier> clsList;
        CsmClassifier ret = null;
        if (ret == null && searchByName && (clsList = finder.findClasses(null, className, true, false)) != null && clsList.size() > 0 && !clsList.isEmpty()) {
            ret = clsList.get(0);
        }
        return ret;
    }

    public CsmClass getClass(CsmFile file, int docPos) {
        int pos = this.doc2context(docPos);
        return CompletionUtilities.findClassOnPosition(file, this.getDocument(), pos);
    }

    public CsmOffsetableDeclaration getDefinition(CsmFile file, int docPos, FileReferencesContext fileContext) {
        int pos = this.doc2context(docPos);
        return CompletionUtilities.findFunDefinitionOrClassOnPosition(file, this.getDocument(), pos, fileContext);
    }

    public boolean isStaticBlock(int docPos) {
        return false;
    }

    public static boolean isAssignable(CsmType from, CsmType to) {
        String tto;
        CsmClassifier fromCls = from.getClassifier();
        CsmClassifier toCls = to.getClassifier();
        if (fromCls == null) {
            return false;
        }
        if (toCls == null) {
            return false;
        }
        if (fromCls.equals(CsmCompletion.NULL_CLASS)) {
            return to.getArrayDepth() > 0 || !CsmCompletion.isPrimitiveClass(toCls);
        }
        if (toCls.equals(CsmCompletion.OBJECT_CLASS)) {
            return from.getArrayDepth() > to.getArrayDepth() || from.getArrayDepth() == to.getArrayDepth() && !CsmCompletion.isPrimitiveClass(fromCls);
        }
        if (from.getArrayDepth() != to.getArrayDepth() || from.getPointerDepth() != to.getPointerDepth()) {
            return false;
        }
        if (fromCls.equals(toCls)) {
            return true;
        }
        String tfrom = ((Object)from.getCanonicalText()).toString().replaceAll("const", "").trim();
        if (tfrom.equals(tto = ((Object)to.getCanonicalText()).toString().replaceAll("const", "").trim())) {
            return true;
        }
        if (CsmKindUtilities.isClass((CsmObject)toCls) && CsmKindUtilities.isClass((CsmObject)fromCls)) {
            return CsmInheritanceUtilities.isAssignableFrom((CsmClass)((CsmClass)fromCls), (CsmClass)((CsmClass)toCls));
        }
        return false;
    }

    public CsmType getCommonType(CsmType typ1, CsmType typ2) {
        if (typ1.equals(typ2)) {
            return typ1;
        }
        if (!CndLexerUtilities.isType((String)((Object)typ1.getClassifier().getName()).toString()) && CndLexerUtilities.isType((String)((Object)typ2.getClassifier().getName()).toString())) {
            if (CompletionSupport.isAssignable(typ1, typ2)) {
                return typ1;
            }
            if (CompletionSupport.isAssignable(typ2, typ1)) {
                return typ2;
            }
            return null;
        }
        if (typ1.getArrayDepth() != typ2.getArrayDepth()) {
            return null;
        }
        return null;
    }

    public static Collection<CsmFunction> filterMethods(Collection<CsmFunction> methodList, List parmTypeList, boolean acceptMoreParameters, boolean acceptIfSameNumberParams) {
        assert (methodList != null);
        if (parmTypeList == null) {
            return methodList;
        }
        ArrayList<CsmFunction> ret = new ArrayList<CsmFunction>();
        int parmTypeCnt = parmTypeList.size();
        int maxMatched = acceptIfSameNumberParams ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (CsmFunction m : methodList) {
            CsmType t;
            CsmParameter[] methodParms = m.getParameters().toArray(new CsmParameter[m.getParameters().size()]);
            if (methodParms.length == parmTypeCnt || acceptMoreParameters && methodParms.length >= parmTypeCnt) {
                boolean accept = true;
                boolean bestMatch = !acceptMoreParameters;
                int matched = 0;
                for (int j = 0; accept && j < parmTypeCnt; ++j) {
                    if (methodParms[j] == null) {
                        System.err.println("Null parameter " + j + " in function " + UIDs.get((Object)m));
                        bestMatch = false;
                        continue;
                    }
                    CsmType mpt = methodParms[j].getType();
                    CsmType t2 = (CsmType)parmTypeList.get(j);
                    if (t2 != null) {
                        if (!methodParms[j].isVarArgs() && !CompletionSupport.equalTypes(t2, mpt)) {
                            bestMatch = false;
                            if (!CompletionSupport.isAssignable(t2, mpt)) {
                                accept = false;
                                continue;
                            }
                            ++matched;
                            continue;
                        }
                        ++matched;
                        continue;
                    }
                    bestMatch = false;
                }
                if (accept) {
                    if (bestMatch) {
                        ret.clear();
                    } else if (matched > maxMatched) {
                        maxMatched = matched;
                        ret.clear();
                    }
                    ret.add(m);
                    if (!bestMatch) continue;
                    break;
                }
                if (matched <= maxMatched) continue;
                maxMatched = matched;
                ret.clear();
                ret.add(m);
                continue;
            }
            if (methodParms.length != 0 || parmTypeCnt != 1 || (t = (CsmType)parmTypeList.get(0)) == null || !"void".equals(t.getText())) continue;
            ret.clear();
            ret.add(m);
        }
        return ret;
    }

    public static boolean isCompletionEnabled(Document doc, int offset) {
        return CompletionSupport.isCompletionEnabled(doc, offset, -1);
    }

    public static boolean isCompletionEnabled(Document doc, int offset, int queryType) {
        TokenId id;
        if (doc.getLength() == 0) {
            return true;
        }
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (offset > 0 ? 1 : 0) != 0);
        if (ts == null) {
            return false;
        }
        if (ts.offset() < offset && offset <= ts.offset() + ts.token().length() && (id = ts.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_DEFINED: {
                    return false;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    return offset == ts.offset() + ts.token().length();
                }
            }
            if ("preprocessor-keyword-directive".equals(ts.token().id().primaryCategory())) {
                return false;
            }
            if (queryType != 4 && "number".equals(ts.token().id().primaryCategory())) {
                return false;
            }
        }
        return true;
    }

    public static boolean needShowCompletionOnText(JTextComponent target, String typedText) throws BadLocationException {
        char typedChar = typedText.charAt(typedText.length() - 1);
        if (typedChar == ' ' || typedChar == '>' || typedChar == ':' || typedChar == '.' || typedChar == '*') {
            int dotPos = target.getCaret().getDot();
            Document doc = target.getDocument();
            TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)dotPos, (boolean)true, (boolean)true);
            if (ts == null) {
                return false;
            }
            Token token = ts.token();
            if (!ts.movePrevious()) {
                return false;
            }
            TokenId id = token.id();
            if (id instanceof CppTokenId) {
                switch ((CppTokenId)id) {
                    case WHITESPACE: {
                        return token.length() == 1 && id == CppTokenId.NEW;
                    }
                    case ARROW: {
                        return true;
                    }
                    case DOT: {
                        return true;
                    }
                    case ARROWMBR: 
                    case DOTMBR: {
                        return true;
                    }
                    case SCOPE: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean equalTypes(CsmType t, CsmType mpt) {
        assert (t != null);
        if (t.equals(mpt)) {
            return true;
        }
        if (mpt != null) {
            String t1 = ((Object)t.getCanonicalText()).toString();
            String t2 = ((Object)mpt.getCanonicalText()).toString();
            return t1.equals(t2);
        }
        return false;
    }

    CsmType findExactVarType(CsmFile file, String var, int docPos, FileReferencesContext refContext) {
        CsmType type;
        if (file == null) {
            return null;
        }
        int pos = this.doc2context(docPos);
        CsmContext context = CsmOffsetResolver.findContext(file, pos, refContext);
        if (var.length() == 0 && CsmKindUtilities.isVariable((CsmObject)context.getLastObject()) && ((CsmVariable)context.getLastObject()).getInitialValue() != null) {
            CsmVariable varObj = (CsmVariable)context.getLastObject();
            String expr = ((Object)varObj.getInitialValue().getText()).toString();
            if (this.findLCurlsNumberBeforPosition(expr, pos - varObj.getInitialValue().getStartOffset()) > 1) {
                String typeName;
                int indexOfRBracket;
                CsmClassifier cls;
                int pos2 = this.findLastAssignmentBeforPosition(expr, pos - varObj.getInitialValue().getStartOffset());
                int pos3 = this.findLastTypeCastBeforPosition(expr, pos - varObj.getInitialValue().getStartOffset());
                if (pos2 != -1 && pos3 < pos2) {
                    type = this.findExactVarType(file, var, varObj.getInitialValue().getStartOffset() + pos2, refContext);
                    if (type != null) {
                        String varName = expr.substring(pos2);
                        varName = varName.substring(1, varName.indexOf("=")).trim();
                        cls = type.getClassifier();
                        if (cls != null && CsmKindUtilities.isClass((CsmObject)(cls = CsmClassifierResolver.getDefault().getOriginalClassifier(cls, file)))) {
                            for (CsmMember csmMember : ((CsmClass)cls).getMembers()) {
                                if (!CsmKindUtilities.isField((CsmObject)csmMember) || !((Object)csmMember.getName()).toString().equals(varName)) continue;
                                return ((CsmField)csmMember).getType();
                            }
                        }
                    }
                } else if (pos3 != -1 && (indexOfRBracket = (typeName = expr.substring(pos3 + 1)).indexOf(")")) > 0) {
                    typeName = typeName.substring(0, indexOfRBracket);
                    cls = CompletionSupport.getClassFromName(this.getFinder(), typeName, true);
                    if (cls != null) {
                        CsmType type2 = CsmCompletion.getType(cls, 0, false, 0, false);
                        return type2;
                    }
                }
            }
            if (CsmOffsetUtilities.isInObject((CsmObject)varObj.getInitialValue(), pos)) {
                CsmClassifier cls;
                CsmType type3 = varObj.getType();
                if (type3.getArrayDepth() > 0 && (cls = type3.getClassifier()) != null) {
                    type3 = CsmCompletion.getType(cls, 0, false, 0, false);
                }
                return type3;
            }
        }
        if (var.length() == 0 && CsmKindUtilities.isStatement((CsmObject)context.getLastObject())) {
            CsmStatement stmt = (CsmStatement)context.getLastObject();
            if (stmt.getKind() == CsmStatement.Kind.RETURN) {
                CsmReturnStatement ret = (CsmReturnStatement)stmt;
                try {
                    String e = this.getDocument().getText(ret.getStartOffset(), ret.getEndOffset() - ret.getStartOffset());
                    String typeName = e.replaceAll("((\\W|\n)*)return((\\W|\n|&)*)\\((.*)\\)((\\W|\n)*)\\{((.|\n)*)\\}((.|\n)*)", "$5");
                    CsmClassifier cls = CompletionSupport.getClassFromName(this.getFinder(), typeName, true);
                    if (cls != null) {
                        CsmType type4 = CsmCompletion.getType(cls, 0, false, 0, false);
                        return type4;
                    }
                }
                catch (BadLocationException ex) {}
            } else if (stmt.getKind() == CsmStatement.Kind.EXPRESSION) {
                try {
                    String e = this.getDocument().getText(stmt.getStartOffset(), stmt.getEndOffset() - stmt.getStartOffset());
                    String typeName = e.replaceAll("((.|\n)*)=((\\W|\n|&)*)\\((.*)\\)((\\W|\n)*)\\{((.|\n)*)\\}((.|\n)*)", "$5");
                    CsmClassifier cls = CompletionSupport.getClassFromName(this.getFinder(), typeName, true);
                    if (cls != null) {
                        type = CsmCompletion.getType(cls, 0, false, 0, false);
                        return type;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }
        for (CsmDeclaration decl : CsmContextUtilities.findFunctionLocalVariables(context)) {
            CsmVariable v;
            if (!CsmKindUtilities.isVariable((CsmObject)decl) || !((Object)(v = (CsmVariable)decl).getName()).toString().equals(var)) continue;
            return v.getType();
        }
        return null;
    }

    private int findLCurlsNumberBeforPosition(String s, int pos) {
        int cursor = -1;
        int cursNumber = 0;
        while ((cursor = s.indexOf(123, cursor + 1)) != -1 && cursor < pos) {
            ++cursNumber;
        }
        return cursNumber;
    }

    private int findLastAssignmentBeforPosition(String s, int pos) {
        int cursor = pos;
        int level = 0;
        while (cursor != -1) {
            if (s.charAt(cursor) == '}') {
                ++level;
            }
            if (s.charAt(cursor) == '{') {
                --level;
            }
            if (level == -1 && s.charAt(cursor) == '.') {
                return cursor;
            }
            --cursor;
        }
        return -1;
    }

    private int findLastTypeCastBeforPosition(String s, int pos) {
        int cursor = pos;
        int level = 0;
        while (cursor != -1) {
            if (s.charAt(cursor) == '}') {
                ++level;
            }
            if (s.charAt(cursor) == '{') {
                --level;
            }
            if (level == -1 && s.charAt(cursor) == '(') {
                return cursor;
            }
            --cursor;
        }
        return -1;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.lastSeparatorOffset = -1;
    }
}

