/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class LocalHistorySettings {
    private static final LocalHistorySettings INSTANCE = new LocalHistorySettings();
    private static final String LAST_SELECTED_ENTRY = "RevertFileChanges.lastSelected";
    private static final String PROP_TTL = "timeToLive";
    private static final String PROP_CLEANUP_LABELED = "noLabelCleanUp";
    private static final String PROP_KEEP_FOREVER = "keepForever";
    private static final String PROP_KEEP_STORED = "filesToKeepStored";

    private LocalHistorySettings() {
    }

    public static LocalHistorySettings getInstance() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(LocalHistorySettings.class);
    }

    public void setTTL(int ttl) {
        this.getPreferences().putInt(PROP_TTL, ttl);
    }

    public int getTTL() {
        return this.getPreferences().getInt(PROP_TTL, 7);
    }

    public void setCleanUpLabeled(boolean selected) {
        this.getPreferences().putBoolean(PROP_CLEANUP_LABELED, selected);
    }

    public boolean getCleanUpLabeled() {
        return this.getPreferences().getBoolean(PROP_CLEANUP_LABELED, true);
    }

    public long getTTLMillis() {
        return (long)this.getTTL() * 24L * 60L * 60L * 1000L;
    }

    public void setLastSelectedEntry(File file, long ts) {
        this.getPreferences().putLong("RevertFileChanges.lastSelected#" + file.getAbsoluteFile(), ts);
    }

    public long getLastSelectedEntry(File file) {
        return this.getPreferences().getLong("RevertFileChanges.lastSelected#" + file.getAbsoluteFile(), -1L);
    }

    public boolean getKeepForever() {
        return this.getPreferences().getBoolean(PROP_KEEP_FOREVER, false);
    }

    public void setKeepForever(boolean forever) {
        this.getPreferences().putBoolean(PROP_KEEP_FOREVER, forever);
    }
}

