/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.options.LocalHistoryOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class LocalHistoryOptionsController
extends OptionsPanelController
implements DocumentListener,
ActionListener {
    private final LocalHistoryOptionsPanel panel = new LocalHistoryOptionsPanel();
    private boolean noLabelValue;
    private String daysValue;

    public LocalHistoryOptionsController() {
        this.panel.warningLabel.setVisible(false);
        this.panel.daysTextField.getDocument().addDocumentListener(this);
        this.panel.keepForeverCheckBox.addActionListener(this);
    }

    public void update() {
        this.daysValue = String.valueOf(LocalHistorySettings.getInstance().getTTL());
        this.panel.daysTextField.setText(this.daysValue);
        this.noLabelValue = !LocalHistorySettings.getInstance().getCleanUpLabeled();
        this.panel.noLabelCleanupCheckBox.setSelected(this.noLabelValue);
        this.panel.keepForeverCheckBox.setSelected(LocalHistorySettings.getInstance().getKeepForever());
        this.updateForeverState();
    }

    public void applyChanges() {
        if (!this.isValid()) {
            return;
        }
        if (this.panel.keepForeverCheckBox.isSelected()) {
            LocalHistorySettings.getInstance().setKeepForever(true);
            LocalHistorySettings.getInstance().setTTL(Integer.parseInt(this.daysValue));
            LocalHistorySettings.getInstance().setCleanUpLabeled(!this.noLabelValue);
        } else {
            LocalHistorySettings.getInstance().setKeepForever(false);
            LocalHistorySettings.getInstance().setTTL(Integer.parseInt(this.panel.daysTextField.getText()));
            LocalHistorySettings.getInstance().setCleanUpLabeled(!this.panel.noLabelCleanupCheckBox.isSelected());
        }
    }

    public void cancel() {
    }

    public boolean isValid() {
        boolean valid = true;
        try {
            if (!this.panel.keepForeverCheckBox.isSelected()) {
                Integer.parseInt(this.panel.daysTextField.getText());
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        this.panel.warningLabel.setVisible(!valid);
        return valid;
    }

    public boolean isChanged() {
        String ttl = Long.toString(LocalHistorySettings.getInstance().getTTL());
        return !ttl.equals(this.panel.daysTextField.getText()) && this.panel.noLabelCleanupCheckBox.isSelected() != LocalHistorySettings.getInstance().getCleanUpLabeled() && this.panel.keepForeverCheckBox.isSelected() != LocalHistorySettings.getInstance().getKeepForever();
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.isValid();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.keepForeverCheckBox) {
            this.updateForeverState();
        }
    }

    private void updateForeverState() {
        if (this.panel.keepForeverCheckBox.isSelected()) {
            this.panel.daysTextField.setEnabled(false);
            this.panel.noLabelCleanupCheckBox.setEnabled(false);
            this.panel.daysLabel1.setEnabled(false);
            this.panel.daysLabel2.setEnabled(false);
            this.panel.noLabelCleanupCheckBox.setEnabled(false);
            this.noLabelValue = this.panel.noLabelCleanupCheckBox.isSelected();
            this.daysValue = this.panel.daysTextField.getText();
            this.panel.noLabelCleanupCheckBox.setSelected(false);
            this.panel.daysTextField.setText("");
        } else {
            this.panel.daysTextField.setEnabled(true);
            this.panel.noLabelCleanupCheckBox.setEnabled(true);
            this.panel.daysLabel1.setEnabled(true);
            this.panel.daysLabel2.setEnabled(true);
            this.panel.noLabelCleanupCheckBox.setSelected(this.noLabelValue);
            this.panel.daysTextField.setText(this.daysValue);
        }
    }
}

