/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.Filter;

public class SuperPatternFilter
extends Filter {
    private List<Integer> toPrevious;
    Pattern pattern;
    String filterStr = "";
    MODE mode;
    private static final String UNKOWN_MODE = "unknown mode";

    public SuperPatternFilter(int col) {
        super(col);
        this.setFilterStr(null, MODE.LITERAL_FIND);
    }

    public boolean isFilterSetTo(String rack, MODE matchMode) {
        return this.filterStr.equals(rack) && this.mode == matchMode;
    }

    public void setFilterStr(String filterStr, MODE mode) {
        if (filterStr == null || this.filterStr.equals(filterStr) && this.mode == mode) {
            return;
        }
        this.filterStr = filterStr;
        this.mode = mode;
        switch (mode) {
            case LITERAL_FIND: 
            case LITERAL_MATCH: {
                break;
            }
            case REGEX_FIND: 
            case REGEX_MATCH: {
                String filterStr2 = filterStr == null || filterStr.length() == 0 ? ".*" : filterStr;
                this.pattern = Pattern.compile(filterStr2, 0);
                break;
            }
            default: {
                throw new RuntimeException(UNKOWN_MODE);
            }
        }
        this.refresh();
    }

    protected void reset() {
        this.toPrevious.clear();
        int inputSize = this.getInputSize();
        this.fromPrevious = new int[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            this.fromPrevious[i] = -1;
        }
    }

    protected void filter() {
        int inputSize = this.getInputSize();
        int current = 0;
        for (int i = 0; i < inputSize; ++i) {
            if (!this.test(i)) continue;
            this.toPrevious.add(i);
            this.fromPrevious[i] = current++;
        }
    }

    public boolean test(int row) {
        int colIdx = this.getColumnIndex();
        if (!this.adapter.isTestable(colIdx)) {
            return false;
        }
        return this.testValue((String)this.getInputValue(row, colIdx));
    }

    boolean testValue(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        switch (this.mode) {
            case LITERAL_FIND: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return valueStr.toUpperCase().contains(this.filterStr.toUpperCase());
            }
            case LITERAL_MATCH: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return this.filterStr.equals(valueStr);
            }
            case REGEX_FIND: {
                return this.pattern.matcher(valueStr).find();
            }
            case REGEX_MATCH: {
                return this.pattern.matcher(valueStr).matches();
            }
        }
        throw new RuntimeException(UNKOWN_MODE);
    }

    public int getSize() {
        return this.toPrevious.size();
    }

    protected int mapTowardModel(int row) {
        return this.toPrevious.get(row);
    }

    protected void init() {
        this.toPrevious = new ArrayList<Integer>();
    }

    public static enum MODE {
        LITERAL_FIND,
        REGEX_FIND,
        LITERAL_MATCH,
        REGEX_MATCH;

    }
}

