/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phpdoc.PhpDocScript;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class PhpDocOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 18784654654113L;
    private static final String PHPDOC_LAST_FOLDER_SUFFIX = ".phpdoc";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseButton;
    private JLabel configInfoLabel;
    private JLabel configLearnMoreLabel;
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JLabel installationLearnMoreLabel;
    private JLabel phpDocLabel;
    private JTextField phpDocTextField;
    private JLabel phpDocUsageLabel;
    private JButton searchButton;

    public PhpDocOptionsPanel() {
        this.initComponents();
        this.phpDocUsageLabel.setText(NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_PhpDocUsage", (Object)PhpDocScript.SCRIPT_NAME_LONG));
        this.errorLabel.setText(" ");
        this.phpDocTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                PhpDocOptionsPanel.this.fireChange();
            }
        });
    }

    public String getPhpDoc() {
        return this.phpDocTextField.getText();
    }

    public void setPhpDoc(String phpDoc) {
        this.phpDocTextField.setText(phpDoc);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void clearError() {
        this.setError(" ");
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.phpDocLabel = new JLabel();
        this.phpDocTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.phpDocUsageLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.installationLearnMoreLabel = new JLabel();
        this.configInfoLabel = new JLabel();
        this.configLearnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.phpDocLabel, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.phpDocLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocOptionsPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpDocOptionsPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpDocUsageLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationLearnMoreLabel, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.installationLearnMoreLabel.text"));
        this.installationLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpDocOptionsPanel.this.installationLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpDocOptionsPanel.this.installationLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.configInfoLabel, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.configInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.configLearnMoreLabel, (String)NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"PhpDocOptionsPanel.configLearnMoreLabel.text"));
        this.configLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpDocOptionsPanel.this.configLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpDocOptionsPanel.this.configLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.phpDocLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpDocUsageLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.phpDocTextField, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.installationInfoLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.installationLearnMoreLabel, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.configInfoLabel, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.configLearnMoreLabel, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpDocLabel).addComponent(this.phpDocTextField, -2, -1, -2).addComponent(this.searchButton).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpDocUsageLabel).addGap(18, 18, 18).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationLearnMoreLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.configInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configLearnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File phpDoc = new FileChooserBuilder(PhpDocOptionsPanel.class.getName() + PHPDOC_LAST_FOLDER_SUFFIX).setTitle(NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_SelectPhpDoc")).setFilesOnly(true).showOpenDialog();
        if (phpDoc != null) {
            phpDoc = FileUtil.normalizeFile((File)phpDoc);
            this.phpDocTextField.setText(phpDoc.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String phpDoc = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"phpdoc", PhpDocScript.SCRIPT_NAME_LONG});
            }

            public String getWindowTitle() {
                return NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_PhpDocsTitle");
            }

            public String getListTitle() {
                return NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_PhpDocs");
            }

            public String getPleaseWaitPart() {
                return NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_PhpDocsPleaseWaitPart");
            }

            public String getNoItemsFound() {
                return NbBundle.getMessage(PhpDocOptionsPanel.class, (String)"LBL_NoPhpDocsFound");
            }
        });
        if (phpDoc != null) {
            this.phpDocTextField.setText(phpDoc);
        }
    }

    private void installationLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installationLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://manual.phpdoc.org/HTMLSmartyConverter/HandS/ric_INSTALL.html");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void configLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void configLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://manual.phpdoc.org/HTMLframesConverter/default/phpDocumentor/tutorial_phpDocumentor.howto.pkg.html#using.command-line");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

