/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.mappings.Association;

public class DirectMapChangeRecord
extends ChangeRecord {
    protected HashMap addObjectsList;
    protected HashMap removeObjectsList;
    protected transient Object originalCollection;
    protected transient Object latestCollection;

    public DirectMapChangeRecord() {
    }

    public DirectMapChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public Vector getAddAssociations() {
        Vector<Association> addAssociations = new Vector<Association>();
        Iterator i = this.getAddObjects().keySet().iterator();
        while (i.hasNext()) {
            Association association = new Association();
            Object key = i.next();
            Object value = this.getAddObjects().get(key);
            association.setKey(key);
            association.setValue(value);
            addAssociations.add(association);
        }
        if (addAssociations.size() == 0) {
            return null;
        }
        return addAssociations;
    }

    public boolean hasChanges() {
        return !this.getAddObjects().isEmpty() || !this.getRemoveObjects().isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        for (Object key : ((DirectMapChangeRecord)mergeFromRecord).getAddObjects().keySet()) {
            if (this.getAddObjects().containsKey(key)) continue;
            if (this.getRemoveObjects().containsKey(key)) {
                this.getRemoveObjects().remove(key);
                continue;
            }
            this.getAddObjects().put(key, ((DirectMapChangeRecord)mergeFromRecord).getAddObjects().get(key));
        }
        for (Object key : ((DirectMapChangeRecord)mergeFromRecord).getRemoveObjects().keySet()) {
            if (this.getRemoveObjects().containsKey(key)) continue;
            if (this.getAddObjects().containsKey(key)) {
                this.getAddObjects().remove(key);
                continue;
            }
            this.getRemoveObjects().put(key, ((DirectMapChangeRecord)mergeFromRecord).getRemoveObjects().get(key));
        }
    }

    public void setAddAssociations(Vector addAssociations) {
        HashMap<Object, Object> addMap = new HashMap<Object, Object>();
        Enumeration enumtr = addAssociations.elements();
        while (enumtr.hasMoreElements()) {
            Association association = (Association)enumtr.nextElement();
            addMap.put(association.getKey(), association.getValue());
        }
        if (addMap.isEmpty()) {
            this.addObjectsList = null;
        }
        this.addObjectsList = addMap;
    }

    public Object getLatestCollection() {
        return this.latestCollection;
    }

    public Object getOriginalCollection() {
        return this.originalCollection;
    }

    public Vector getRemoveAssociations() {
        Vector<Association> removeAssociations = new Vector<Association>();
        Iterator i = this.getRemoveObjects().keySet().iterator();
        while (i.hasNext()) {
            Association association = new Association();
            Object key = i.next();
            Object value = this.getAddObjects().get(key);
            association.setKey(key);
            association.setValue(value);
            removeAssociations.add(association);
        }
        if (removeAssociations.size() == 0) {
            return null;
        }
        return removeAssociations;
    }

    public void setRemoveAssociations(Vector removeAssociations) {
        HashMap<Object, Object> removeMap = new HashMap<Object, Object>();
        Enumeration enumtr = removeAssociations.elements();
        while (enumtr.hasMoreElements()) {
            Association association = (Association)enumtr.nextElement();
            removeMap.put(association.getKey(), association.getValue());
        }
        if (removeMap.isEmpty()) {
            this.removeObjectsList = null;
        }
        this.removeObjectsList = removeMap;
    }

    public void addAdditionChange(HashMap additions) {
        if (this.getAddObjects().size() == 0) {
            this.addObjectsList = additions;
            return;
        }
        for (Object key : additions.keySet()) {
            if (this.getAddObjects().containsKey(key)) {
                this.getAddObjects().put(key, additions.get(key));
                continue;
            }
            if (!additions.get(key).equals(this.getAddObjects().get(key))) continue;
            this.getAddObjects().put(key, additions.get(key));
        }
    }

    public void addRemoveChange(HashMap subtractions) {
        if (this.getRemoveObjects().size() == 0) {
            this.removeObjectsList = subtractions;
            return;
        }
        for (Object key : subtractions.keySet()) {
            if (!this.getRemoveObjects().containsKey(key)) {
                this.getRemoveObjects().put(key, subtractions.get(key));
                continue;
            }
            if (!subtractions.get(key).equals(this.getRemoveObjects().get(key))) continue;
            this.getRemoveObjects().put(key, subtractions.get(key));
        }
    }

    public void addAdditionChange(Object key, Object value) {
        if (this.getRemoveObjects().containsKey(key)) {
            if (value.equals(this.getRemoveObjects().get(key))) {
                this.getRemoveObjects().remove(key);
            } else {
                this.getAddObjects().put(key, value);
            }
        } else {
            this.getAddObjects().put(key, value);
        }
    }

    public void addRemoveChange(Object key, Object value) {
        if (this.getAddObjects().containsKey(key)) {
            this.getAddObjects().remove(key);
        } else if (!this.getRemoveObjects().containsKey(key)) {
            this.getRemoveObjects().put(key, value);
        }
    }

    public void setAddObjects(HashMap addObjects) {
        this.addObjectsList = addObjects;
    }

    public void setLatestCollection(Object latestCollection) {
        this.latestCollection = latestCollection;
    }

    public void setOriginalCollection(Object originalCollection) {
        this.originalCollection = originalCollection;
    }

    public HashMap getAddObjects() {
        if (this.addObjectsList == null) {
            this.addObjectsList = new HashMap();
        }
        return this.addObjectsList;
    }

    public void setRemoveObjects(HashMap removeObjects) {
        this.removeObjectsList = removeObjects;
    }

    public HashMap getRemoveObjects() {
        if (this.removeObjectsList == null) {
            this.removeObjectsList = new HashMap();
        }
        return this.removeObjectsList;
    }

    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
    }
}

