/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

public class HibernateMappingRenameTransaction
extends RenameTransaction {
    private final String rescrName = "Resource";
    private boolean pathOnly = false;

    public HibernateMappingRenameTransaction(Set<FileObject> files, String origName, String newName) {
        this(files, origName, newName, false);
    }

    public HibernateMappingRenameTransaction(Set<FileObject> files, String origName, String newName, boolean pathOnly) {
        super(files, origName, newName);
        this.pathOnly = pathOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        for (FileObject file : this.getToBeModifiedFiles()) {
            OutputStream outs = null;
            try {
                InputStream is = file.getInputStream();
                HibernateConfiguration configuration = HibernateConfiguration.createGraph(is);
                SessionFactory sfactory = configuration.getSessionFactory();
                if (sfactory != null) {
                    for (int i = 0; i < sfactory.sizeMapping(); ++i) {
                        int lastIndex;
                        String resourceName = sfactory.getAttributeValue("Mapping", i, "Resource");
                        if (resourceName == null) continue;
                        String comparePart = resourceName;
                        String newResourceName = this.newName;
                        if (this.pathOnly && (lastIndex = resourceName.lastIndexOf(47)) > -1) {
                            comparePart = resourceName.substring(0, lastIndex);
                            newResourceName = newResourceName + "/" + resourceName.substring(resourceName.lastIndexOf(47) + 1);
                        }
                        if (!comparePart.equals(this.origName)) continue;
                        sfactory.setAttributeValue("Mapping", i, "Resource", newResourceName);
                    }
                }
                outs = file.getOutputStream();
                configuration.write(outs);
            }
            catch (FileAlreadyLockedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                try {
                    if (outs == null) continue;
                    outs.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }
}

