/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.php.api.phpmodule.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.SmartyPhpModuleCustomizerExtender;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleIgnoredFilesExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SmartyPhpFrameworkProvider
extends PhpFrameworkProvider {
    private static final Logger LOGGER = Logger.getLogger(SmartyPhpFrameworkProvider.class.getName());
    public static final String PROP_SMARTY_AVAILABLE = "smarty-framework";
    private static final String ICON_PATH = "org/netbeans/modules/php/smarty/resources/smarty-badge-8.png";
    private static final SmartyPhpFrameworkProvider INSTANCE = new SmartyPhpFrameworkProvider();
    private final BadgeIcon badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/smarty/resources/smarty-badge-8.png"), SmartyPhpFrameworkProvider.class.getResource("/org/netbeans/modules/php/smarty/resources/smarty-badge-8.png"));

    public static SmartyPhpFrameworkProvider getInstance() {
        return INSTANCE;
    }

    private SmartyPhpFrameworkProvider() {
        super("Smarty PHP Web Framework", NbBundle.getMessage(SmartyPhpFrameworkProvider.class, (String)"LBL_FrameworkName"), NbBundle.getMessage(SmartyPhpFrameworkProvider.class, (String)"LBL_FrameworkDescription"));
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public static boolean hasSmartyTemplateExtension(FileObject fo) {
        return "text/x-tpl".equals(FileUtil.getMIMEType((FileObject)fo, (String[])new String[]{"text/x-tpl"}));
    }

    public static boolean locatedTplFiles(FileObject fo, int maxDepth, int actualDepth) {
        while (actualDepth <= maxDepth) {
            for (FileObject child : fo.getChildren()) {
                if (!(!child.isFolder() ? SmartyPhpFrameworkProvider.hasSmartyTemplateExtension(child) : child.isFolder() && actualDepth < maxDepth && SmartyPhpFrameworkProvider.locatedTplFiles(child, maxDepth, actualDepth + 1))) continue;
                return true;
            }
            ++actualDepth;
        }
        return false;
    }

    public static FileObject locate(PhpModule phpModule, String relativePath, boolean subdirs) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null || !subdirs) {
            return fileObject;
        }
        for (FileObject child : sourceDirectory.getChildren()) {
            fileObject = child.getFileObject(relativePath);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInPhpModule(final PhpModule phpModule) {
        long time = System.currentTimeMillis();
        try {
            final AtomicBoolean isSmartyFound = new AtomicBoolean(false);
            Preferences preferences = phpModule.getPreferences(SmartyPhpFrameworkProvider.class, true);
            SmartyOptions.updateSmartyScanningDepthProperty();
            this.updateSmartyAvailableProperty(preferences);
            if (preferences.getBoolean(PROP_SMARTY_AVAILABLE, false)) {
                boolean bl = true;
                return bl;
            }
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileObject sourceDirectory = phpModule.getSourceDirectory();
                    int scanningDepth = SmartyFramework.getDepthOfScanningForTpl();
                    LOGGER.log(Level.FINEST, "Locating for Smarty templates in depth={0}", scanningDepth);
                    if (SmartyPhpFrameworkProvider.locatedTplFiles(sourceDirectory, scanningDepth, 0)) {
                        isSmartyFound.set(true);
                    }
                }
            }, (String)NbBundle.getMessage(SmartyPhpFrameworkProvider.class, (String)"MSG_SearchingForSmartyExt"), (AtomicBoolean)new AtomicBoolean(false), (boolean)false, (int)1000, (int)10000);
            if (isSmartyFound.get()) {
                preferences.putBoolean(PROP_SMARTY_AVAILABLE, true);
            }
            boolean bl = isSmartyFound.get();
            return bl;
        }
        finally {
            LOGGER.log(Level.FINE, "Smarty.isInPhpModule total time spent={0} ms", System.currentTimeMillis() - time);
        }
    }

    private void updateSmartyAvailableProperty(Preferences preferences) {
        if (preferences.get(PROP_SMARTY_AVAILABLE, "0").equals("1")) {
            preferences.putBoolean(PROP_SMARTY_AVAILABLE, true);
        }
    }

    public File[] getConfigurationFiles(PhpModule phpModule) {
        return new File[0];
    }

    public PhpModuleExtender createPhpModuleExtender(PhpModule phpModule) {
        return null;
    }

    public PhpModuleProperties getPhpModuleProperties(PhpModule phpModule) {
        FileObject testUnit;
        PhpModuleProperties properties = new PhpModuleProperties();
        FileObject web = SmartyPhpFrameworkProvider.locate(phpModule, "web", true);
        if (web != null) {
            properties = properties.setWebRoot(web);
        }
        if ((testUnit = SmartyPhpFrameworkProvider.locate(phpModule, "test/unit", true)) != null) {
            properties = properties.setTests(testUnit);
        }
        return properties;
    }

    public PhpModuleActionsExtender getActionsExtender(PhpModule phpModule) {
        return null;
    }

    public PhpModuleIgnoredFilesExtender getIgnoredFilesExtender(PhpModule phpModule) {
        return null;
    }

    public FrameworkCommandSupport getFrameworkCommandSupport(PhpModule phpModule) {
        return null;
    }

    public EditorExtender getEditorExtender(PhpModule phpModule) {
        return null;
    }

    public PhpModuleCustomizerExtender createPhpModuleCustomizerExtender(PhpModule phpModule) {
        return new SmartyPhpModuleCustomizerExtender(phpModule);
    }

    private static final class SmartyVerificationVisitor
    extends DefaultVisitor {
        private boolean foundSmarty = false;

        public void visit(ClassInstanceCreation node) {
            NamespaceName name;
            super.visit(node);
            if (node.getClassName().getName() instanceof NamespaceName && !(name = (NamespaceName)node.getClassName().getName()).getSegments().isEmpty() && ((Identifier)name.getSegments().iterator().next()).getName().equals("Smarty")) {
                this.foundSmarty = true;
            }
        }

        public boolean isFoundSmarty() {
            return this.foundSmarty;
        }
    }
}

