/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum GlobberStrategy {
    ANYTHING{

        final Object compile(String glob) {
            return null;
        }

        final boolean matches(Object globPattern, String filename) {
            return true;
        }
    }
    ,
    SUFFIX{

        final Object compile(String glob) {
            return glob.substring(1);
        }

        final boolean matches(Object globPattern, String filename) {
            return filename.endsWith((String)globPattern);
        }
    }
    ,
    PREFIX{

        final Object compile(String glob) {
            return glob.substring(0, glob.length() - 1);
        }

        final boolean matches(Object globPattern, String filename) {
            return 3.basename(filename).startsWith((String)globPattern);
        }
    }
    ,
    EXACT{

        final Object compile(String glob) {
            return glob;
        }

        final boolean matches(Object globPattern, String filename) {
            return globPattern.equals(4.basename(filename));
        }
    }
    ,
    PATTERN{

        final Object compile(String glob) {
            return Pattern.compile("\\Q" + glob.replaceAll("\\*+", "\\\\E.*\\\\Q") + "\\E");
        }

        final boolean matches(Object globPattern, String filename) {
            return ((Pattern)globPattern).matcher(5.basename(filename)).matches();
        }
    };


    static final GlobberStrategy selectFor(String glob) {
        if (null == glob || "*".equals(glob)) {
            return ANYTHING;
        }
        int firstWildcard = glob.indexOf(42);
        if (firstWildcard < 0) {
            return EXACT;
        }
        int lastWildcard = glob.lastIndexOf(42);
        if (firstWildcard == lastWildcard) {
            if (firstWildcard == 0) {
                return SUFFIX;
            }
            if (lastWildcard == glob.length() - 1) {
                return PREFIX;
            }
        }
        return PATTERN;
    }

    abstract Object compile(String var1);

    abstract boolean matches(Object var1, String var2);

    static final String basename(String filename) {
        return filename.substring(1 + filename.lastIndexOf(47));
    }
}

