/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.netbeans.modules.cnd.repository.sfs.SharedStringBuffer;
import org.openide.util.CharSequences;

public class UTF {
    public static int writeUTF(CharSequence str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = null;
        if (out instanceof SharedStringBuffer && ((SharedStringBuffer)((Object)out)).getSharedArrayLehgth() >= utflen + 2) {
            SharedStringBuffer dis = (SharedStringBuffer)((Object)out);
            bytearr = dis.getSharedByteArray();
        } else {
            bytearr = new byte[utflen + 2];
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen + 2);
        return utflen + 2;
    }

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public static CharSequence readCharSequenceUTF(DataInput in) throws IOException {
        int c;
        int count;
        int utflen = in.readUnsignedShort();
        byte[] bytearr = null;
        char[] chararr = null;
        if (in instanceof SharedStringBuffer && ((SharedStringBuffer)((Object)in)).getSharedArrayLehgth() >= utflen) {
            SharedStringBuffer dis = (SharedStringBuffer)((Object)in);
            chararr = dis.getSharedCharArray();
            bytearr = dis.getSharedByteArray();
        } else {
            bytearr = new byte[utflen];
            chararr = new char[utflen];
        }
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            int c2 = bytearr[count] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c2;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c2 & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c2 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return CharSequences.create((char[])chararr, (int)0, (int)chararr_count);
    }
}

