/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.options.DisablingCellRenderer;
import org.netbeans.modules.debugger.jpda.ui.options.StorablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CategoryPanelStepFilters
extends StorablePanel {
    private JButton filterAddButton;
    private JLabel filterClassesLabel;
    private JScrollPane filterClassesScrollPane;
    private JTable filterClassesTable;
    private JCheckBox filterConstructorsCheckBox;
    private JButton filterRemoveButton;
    private JCheckBox filterStaticInitCheckBox;
    private JCheckBox filterSyntheticCheckBox;
    private JButton filtersCheckAllButton;
    private JButton filtersUncheckAllButton;
    private JCheckBox stepThroughFiltersCheckBox;
    private JCheckBox useStepFiltersCheckBox;

    public CategoryPanelStepFilters() {
        this.initComponents();
        this.initFilterClassesList();
        this.filterClassesTable.getColumnModel().getColumn(0).setPreferredWidth(new JCheckBox().getPreferredSize().width);
        this.filterClassesTable.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
        this.filterClassesTable.getColumnModel().getColumn(0).setResizable(false);
        this.filterClassesTable.getColumnModel().getColumn(1).setResizable(true);
        this.filterClassesTable.setRowHeight(Math.max(new JCheckBox().getPreferredSize().height, new JLabel((String)"W").getPreferredSize().height));
        DisablingCellRenderer.apply(this.filterClassesTable);
        this.useStepFiltersCheckBoxActionPerformed(null);
    }

    private void initComponents() {
        this.useStepFiltersCheckBox = new JCheckBox();
        this.filterSyntheticCheckBox = new JCheckBox();
        this.filterStaticInitCheckBox = new JCheckBox();
        this.filterConstructorsCheckBox = new JCheckBox();
        this.filterClassesLabel = new JLabel();
        this.filterClassesScrollPane = new JScrollPane();
        this.filterClassesTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return true;
            }
        };
        this.stepThroughFiltersCheckBox = new JCheckBox();
        this.filterAddButton = new JButton();
        this.filterRemoveButton = new JButton();
        this.filtersCheckAllButton = new JButton();
        this.filtersUncheckAllButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.useStepFiltersCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.useStepFiltersCheckBox.text"));
        this.useStepFiltersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelStepFilters.this.useStepFiltersCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterSyntheticCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterSyntheticCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterStaticInitCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterStaticInitCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterConstructorsCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterConstructorsCheckBox.text"));
        this.filterClassesLabel.setLabelFor(this.filterClassesTable);
        Mnemonics.setLocalizedText((JLabel)this.filterClassesLabel, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.text"));
        this.filterClassesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}){
            Class[] types;
            {
                this.types = new Class[]{Boolean.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.filterClassesTable.setShowHorizontalLines(false);
        this.filterClassesTable.setShowVerticalLines(false);
        this.filterClassesTable.setTableHeader(null);
        this.filterClassesScrollPane.setViewportView(this.filterClassesTable);
        this.filterClassesTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.a11y.name"));
        this.filterClassesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.a11y.description"));
        Mnemonics.setLocalizedText((AbstractButton)this.stepThroughFiltersCheckBox, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.stepThroughFiltersCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.filterAddButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterAddButton.text"));
        this.filterAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelStepFilters.this.filterAddButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterRemoveButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterRemoveButton.text"));
        this.filterRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelStepFilters.this.filterRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filtersCheckAllButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersCheckAllButton.text"));
        this.filtersCheckAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelStepFilters.this.filtersCheckAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filtersUncheckAllButton, (String)NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersUncheckAllButton.text"));
        this.filtersUncheckAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryPanelStepFilters.this.filtersUncheckAllButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useStepFiltersCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stepThroughFiltersCheckBox, -1, 553, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterStaticInitCheckBox).addComponent(this.filterSyntheticCheckBox).addComponent(this.filterConstructorsCheckBox).addComponent(this.filterClassesLabel).addComponent(this.filterClassesScrollPane, -1, 432, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterAddButton).addComponent(this.filterRemoveButton).addComponent(this.filtersCheckAllButton).addComponent(this.filtersUncheckAllButton))))))));
        layout.linkSize(0, this.filterAddButton, this.filterRemoveButton, this.filtersCheckAllButton, this.filtersUncheckAllButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.useStepFiltersCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterSyntheticCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterStaticInitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterConstructorsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterClassesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filterAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterRemoveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersCheckAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersUncheckAllButton).addGap(36, 36, 36)).addComponent(this.filterClassesScrollPane, -1, 154, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepThroughFiltersCheckBox).addContainerGap()));
        this.useStepFiltersCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.useStepFiltersCheckBox.AccessibleContext.accessibleDescription"));
        this.filterSyntheticCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterSyntheticCheckBox.AccessibleContext.accessibleDescription"));
        this.filterStaticInitCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterStaticInitCheckBox.AccessibleContext.accessibleDescription"));
        this.filterConstructorsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterConstructorsCheckBox.AccessibleContext.accessibleDescription"));
        this.filterClassesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterClassesLabel.AccessibleContext.accessibleDescription"));
        this.stepThroughFiltersCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.stepThroughFiltersCheckBox.AccessibleContext.accessibleDescription"));
        this.filterAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterAddButton.AccessibleContext.accessibleDescription"));
        this.filterRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filterRemoveButton.AccessibleContext.accessibleDescription"));
        this.filtersCheckAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersCheckAllButton.AccessibleContext.accessibleDescription"));
        this.filtersUncheckAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CategoryPanelStepFilters.class, (String)"CategoryPanelStepFilters.filtersUncheckAllButton.AccessibleContext.accessibleDescription"));
    }

    private void initFilterClassesList() {
        this.filterClassesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(CategoryPanelStepFilters.this.filterClassesTable.getSelectedRow() >= 0);
            }
        });
        this.filterRemoveButton.setEnabled(this.filterClassesTable.getSelectedRow() >= 0);
        this.filterClassesTable.setSelectionMode(0);
    }

    private void useStepFiltersCheckBoxActionPerformed(ActionEvent evt) {
        boolean enabled = this.useStepFiltersCheckBox.isSelected();
        this.filterSyntheticCheckBox.setEnabled(enabled);
        this.filterStaticInitCheckBox.setEnabled(enabled);
        this.filterConstructorsCheckBox.setEnabled(enabled);
        this.filterClassesLabel.setEnabled(enabled);
        this.filterClassesTable.setEnabled(enabled);
        this.filterClassesScrollPane.setEnabled(enabled);
        this.filterAddButton.setEnabled(enabled);
        this.filterRemoveButton.setEnabled(enabled && this.filterClassesTable.getSelectedRow() >= 0);
        this.filtersCheckAllButton.setEnabled(enabled);
        this.filtersUncheckAllButton.setEnabled(enabled);
        this.stepThroughFiltersCheckBox.setEnabled(enabled);
    }

    private void filterAddButtonActionPerformed(ActionEvent evt) {
        final DefaultTableModel model = (DefaultTableModel)this.filterClassesTable.getModel();
        model.addRow(new Object[]{Boolean.TRUE, ""});
        final int index = model.getRowCount() - 1;
        this.filterClassesTable.getSelectionModel().setSelectionInterval(index, index);
        this.filterClassesTable.editCellAt(index, 1);
        this.filterClassesTable.getEditorComponent().requestFocus();
        this.filterRemoveButton.setEnabled(false);
        this.filterAddButton.setEnabled(false);
        this.filterClassesTable.getCellEditor(index, 1).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String value;
                        if (index < CategoryPanelStepFilters.this.filterClassesTable.getRowCount() && (value = (String)model.getValueAt(index, 1)).trim().length() == 0) {
                            model.removeRow(index);
                        }
                    }
                });
                CategoryPanelStepFilters.this.filterClassesTable.getCellEditor(index, 1).removeCellEditorListener(this);
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(true);
                CategoryPanelStepFilters.this.filterAddButton.setEnabled(true);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                model.removeRow(index);
                CategoryPanelStepFilters.this.filterClassesTable.getCellEditor(index, 1).removeCellEditorListener(this);
                CategoryPanelStepFilters.this.filterRemoveButton.setEnabled(true);
                CategoryPanelStepFilters.this.filterAddButton.setEnabled(true);
            }
        });
    }

    private void filterRemoveButtonActionPerformed(ActionEvent evt) {
        int index = this.filterClassesTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.filterClassesTable.getModel();
        model.removeRow(index);
        if (index < this.filterClassesTable.getRowCount() || --index >= 0) {
            this.filterClassesTable.setRowSelectionInterval(index, index);
        }
    }

    private void filtersCheckAllButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.filterClassesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(Boolean.TRUE, i, 0);
        }
        this.filterClassesTable.repaint();
    }

    private void filtersUncheckAllButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.filterClassesTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(Boolean.FALSE, i, 0);
        }
        this.filterClassesTable.repaint();
    }

    @Override
    public void load() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        this.useStepFiltersCheckBox.setSelected(p.getBoolean("UseStepFilters", true));
        this.filterSyntheticCheckBox.setSelected(p.getBoolean("FilterSyntheticMethods", true));
        this.filterStaticInitCheckBox.setSelected(p.getBoolean("FilterStaticInitializers", false));
        this.filterConstructorsCheckBox.setSelected(p.getBoolean("FilterConstructors", false));
        DefaultTableModel filterClassesModel = (DefaultTableModel)this.filterClassesTable.getModel();
        Set enabledFilters = (Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET);
        Set allFilters = (Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("all", (Collection)Collections.EMPTY_SET);
        filterClassesModel.setRowCount(0);
        for (String filter : allFilters) {
            filterClassesModel.addRow(new Object[]{enabledFilters.contains(filter), filter});
        }
        this.stepThroughFiltersCheckBox.setSelected(p.getBoolean("StepThroughFilters", false));
        this.useStepFiltersCheckBoxActionPerformed(null);
    }

    @Override
    public void store() {
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        p.setBoolean("UseStepFilters", this.useStepFiltersCheckBox.isSelected());
        p.setBoolean("FilterSyntheticMethods", this.filterSyntheticCheckBox.isSelected());
        p.setBoolean("FilterStaticInitializers", this.filterStaticInitCheckBox.isSelected());
        p.setBoolean("FilterConstructors", this.filterConstructorsCheckBox.isSelected());
        TableModel filterClassesModel = this.filterClassesTable.getModel();
        LinkedHashSet<String> allFilters = new LinkedHashSet<String>();
        HashSet<String> enabledFilters = new HashSet<String>();
        int n = filterClassesModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean isEnabled = (Boolean)filterClassesModel.getValueAt(i, 0);
            String clazz = (String)filterClassesModel.getValueAt(i, 1);
            allFilters.add(clazz);
            if (!isEnabled) continue;
            enabledFilters.add(clazz);
        }
        Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").setCollection("all", allFilters);
        Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").setCollection("enabled", enabledFilters);
        p.setBoolean("StepThroughFilters", this.stepThroughFiltersCheckBox.isSelected());
    }
}

