/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelFormatters;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelGeneral;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelStepFilters;
import org.netbeans.modules.debugger.jpda.ui.options.JavaDebuggerOptionsPanelController;
import org.netbeans.modules.debugger.jpda.ui.options.StorablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class JavaDebuggerPanel
extends StorablePanel {
    private static final String SHOW_FORMATTERS_PROP_NAME = "org.netbeans.modules.debugger.jpda.ui.options.SHOW_FORMATTERS";
    private static final int FORMATTERS_INDEX = 2;
    private final JavaDebuggerOptionsPanelController controller;
    private StorablePanel[] categoryPanels;
    private ButtonGroup categoriesButtonGroup;
    private JLabel categoriesLabel;
    private JList categoriesList;
    private JPanel categoriesPanel;
    private JPanel categoryPanel;

    JavaDebuggerPanel(JavaDebuggerOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        Collection panelProviders = Lookups.forPath((String)"debugger/jpda/options").lookupAll(StorablePanel.Provider.class);
        this.categoryPanels = new StorablePanel[3 + panelProviders.size()];
        final String[] panelNames = new String[3 + panelProviders.size()];
        int i = 0;
        this.categoryPanels[i] = new CategoryPanelGeneral();
        panelNames[i++] = NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonGeneral.text");
        this.categoryPanels[i] = new CategoryPanelStepFilters();
        panelNames[i++] = NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonStepFilters.text");
        this.categoryPanels[i] = new CategoryPanelFormatters();
        panelNames[i++] = NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoryRadioButtonFormatters.text");
        for (StorablePanel.Provider p : panelProviders) {
            this.categoryPanels[i] = p.getPanel();
            panelNames[i++] = p.getPanelName();
        }
        this.categoriesList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return panelNames.length;
            }

            @Override
            public Object getElementAt(int i) {
                return panelNames[i];
            }
        });
        String value = System.getProperty(SHOW_FORMATTERS_PROP_NAME);
        int index = value != null && "true".equals(value) ? 2 : 0;
        this.selectCategory(index);
        this.categoriesList.setSelectedIndex(index);
        if (index == 2) {
            System.setProperty(SHOW_FORMATTERS_PROP_NAME, "false");
        }
    }

    private void initComponents() {
        this.categoriesButtonGroup = new ButtonGroup();
        this.categoryPanel = new JPanel();
        this.categoriesPanel = new JPanel();
        this.categoriesList = new JList();
        this.categoriesLabel = new JLabel();
        this.categoryPanel.setLayout(new BoxLayout(this.categoryPanel, 2));
        this.categoriesPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoriesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"General", "Step Filters", "Variable Formatters"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.categoriesList.setSelectionMode(0);
        this.categoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JavaDebuggerPanel.this.categoriesListValueChanged(evt);
            }
        });
        GroupLayout categoriesPanelLayout = new GroupLayout(this.categoriesPanel);
        this.categoriesPanel.setLayout(categoriesPanelLayout);
        categoriesPanelLayout.setHorizontalGroup(categoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoriesList, -1, -1, Short.MAX_VALUE));
        categoriesPanelLayout.setVerticalGroup(categoriesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoriesList, GroupLayout.Alignment.TRAILING, -1, 328, Short.MAX_VALUE));
        this.categoriesLabel.setLabelFor(this.categoriesList);
        Mnemonics.setLocalizedText((JLabel)this.categoriesLabel, (String)NbBundle.getMessage(JavaDebuggerPanel.class, (String)"JavaDebuggerPanel.categoriesLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoriesLabel).addGroup(layout.createSequentialGroup().addComponent(this.categoriesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.categoryPanel, -1, 450, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.categoriesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryPanel, -1, 332, Short.MAX_VALUE).addComponent(this.categoriesPanel, -1, -1, Short.MAX_VALUE))));
        this.categoriesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaDebuggerPanel.class, (String)"Categories_description"));
    }

    private void categoriesListValueChanged(ListSelectionEvent evt) {
        int c = this.categoriesList.getSelectedIndex();
        if (c >= 0 && c <= 3) {
            this.selectCategory(c);
        }
    }

    private void selectCategory(int c) {
        if (this.categoryPanel.getComponentCount() > 0) {
            this.categoryPanel.removeAll();
        }
        this.categoryPanel.add(this.categoryPanels[c]);
        this.categoryPanel.revalidate();
        this.categoryPanel.repaint();
    }

    @Override
    public void load() {
        for (StorablePanel p : this.categoryPanels) {
            p.load();
        }
        String value = System.getProperty(SHOW_FORMATTERS_PROP_NAME);
        if (value != null && "true".equals(value)) {
            this.selectCategory(2);
            this.categoriesList.setSelectedIndex(2);
            System.setProperty(SHOW_FORMATTERS_PROP_NAME, "false");
        }
    }

    @Override
    public void store() {
        for (StorablePanel p : this.categoryPanels) {
            p.store();
        }
    }

    boolean valid() {
        return true;
    }
}

