/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class JavadocAndSourceRootDetection {
    private static final int HOW_MANY_DIRS_TO_TRAVERSE_DEEP = 5;
    private static final Logger LOG = Logger.getLogger(JavadocAndSourceRootDetection.class.getName());
    static final Pattern JAVA_FILE;
    static final Pattern PACKAGE_INFO;

    private JavadocAndSourceRootDetection() {
    }

    public static FileObject findJavadocRoot(FileObject baseFolder) {
        Parameters.notNull((CharSequence)"baseFolder", (Object)baseFolder);
        if (!baseFolder.isFolder()) {
            throw new IllegalArgumentException("baseFolder must be folder - " + baseFolder);
        }
        return JavadocAndSourceRootDetection.findJavadocRoot(baseFolder, 0);
    }

    public static FileObject findSourceRoot(FileObject fo) {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        if (!fo.isFolder()) {
            throw new IllegalArgumentException("fo must be folder - " + fo);
        }
        FileObject root = JavadocAndSourceRootDetection.findJavaSourceFile(fo, 0);
        if (root != null) {
            return JavadocAndSourceRootDetection.findPackageRoot(root);
        }
        return null;
    }

    public static Set<? extends FileObject> findSourceRoots(@NonNull FileObject folder, @NullAllowed AtomicBoolean canceled) {
        Parameters.notNull((CharSequence)"folder", (Object)folder);
        if (!folder.isValid()) {
            throw new IllegalArgumentException("Folder: " + FileUtil.getFileDisplayName((FileObject)folder) + " is not valid.");
        }
        if (!folder.isFolder()) {
            throw new IllegalArgumentException("The parameter: " + FileUtil.getFileDisplayName((FileObject)folder) + " has to be a directory.");
        }
        HashSet result = new HashSet();
        JavadocAndSourceRootDetection.findAllSourceRoots(folder, result, canceled, 0);
        return Collections.unmodifiableSet(result);
    }

    public static FileObject findPackageRoot(FileObject fo) {
        if ("java".equals(fo.getExt())) {
            return JavadocAndSourceRootDetection.findJavaPackage(fo);
        }
        if ("class".equals(fo.getExt())) {
            return JavadocAndSourceRootDetection.findClassPackage(fo);
        }
        throw new IllegalArgumentException("only java or class files accepted " + fo);
    }

    private static FileObject findAllSourceRoots(FileObject folder, Collection<? super FileObject> result, AtomicBoolean canceled, int depth) {
        FileObject[] children;
        if (depth == 50) {
            return null;
        }
        for (FileObject child : children = folder.getChildren()) {
            FileObject upTo;
            if (canceled != null && canceled.get()) {
                return null;
            }
            if (child.isData() && "text/x-java".equals(FileUtil.getMIMEType((FileObject)child, (String[])new String[]{"text/x-java"}))) {
                FileObject root = JavadocAndSourceRootDetection.findPackageRoot(child);
                if (root != null) {
                    result.add((FileObject)root);
                }
                return root;
            }
            if (!child.isFolder() || (upTo = JavadocAndSourceRootDetection.findAllSourceRoots(child, result, canceled, depth + 1)) == null || upTo.equals(child)) continue;
            return upTo;
        }
        return null;
    }

    private static FileObject findJavadocRoot(FileObject fo, int level) {
        FileObject fo1 = fo.getFileObject("package-list", null);
        if (fo1 != null) {
            return fo;
        }
        if (level == 5) {
            return null;
        }
        for (FileObject fo2 : fo.getChildren()) {
            if (!fo2.isFolder() || (fo2 = JavadocAndSourceRootDetection.findJavadocRoot(fo2, level + 1)) == null) continue;
            return fo2;
        }
        return null;
    }

    private static FileObject findJavaSourceFile(FileObject fo, int level) {
        if (level == 999) {
            return null;
        }
        for (FileObject fo2 : fo.getChildren()) {
            if (!fo2.isData() || !"java".equals(fo2.getExt())) continue;
            return fo2;
        }
        for (FileObject fo2 : fo.getChildren()) {
            if (!fo2.isFolder() || (fo2 = JavadocAndSourceRootDetection.findJavaSourceFile(fo2, level + 1)) == null) continue;
            return fo2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"OS_OPEN_STREAM", "RR_NOT_CHECKED"})
    private static FileObject findJavaPackage(FileObject fo) {
        try {
            InputStream is = fo.getInputStream();
            try {
                int read;
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                ((Reader)r).mark(2);
                char[] cbuf = new char[2];
                ((Reader)r).read(cbuf, 0, 2);
                if (cbuf[0] == '\u00ff' && cbuf[1] == '\u00fe') {
                    is.close();
                    is = fo.getInputStream();
                    r = new BufferedReader(new InputStreamReader(is, "Unicode"));
                } else {
                    ((Reader)r).reset();
                }
                StringBuilder b = new StringBuilder((int)fo.getSize());
                char[] buf = new char[b.length() + 1];
                while ((read = r.read(buf)) != -1) {
                    b.append(buf, 0, read);
                }
                Matcher m = (fo.getNameExt().equals("package-info.java") ? PACKAGE_INFO : JAVA_FILE).matcher(b);
                if (m.matches()) {
                    String pkg = m.group(1);
                    LOG.log(Level.FINE, "Found package declaration {0} in {1}", new Object[]{pkg, fo});
                    FileObject fileObject = JavadocAndSourceRootDetection.getPackageRoot(fo, pkg);
                    return fileObject;
                }
                FileObject fileObject = null;
                return fileObject;
            }
            finally {
                is.close();
            }
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
            return null;
        }
    }

    private static FileObject getPackageRoot(FileObject javaOrClassFile, String packageName) {
        String suffix = '/' + packageName.replace('.', '/') + '/' + javaOrClassFile.getNameExt();
        String fpath = javaOrClassFile.getPath();
        if (fpath.endsWith(suffix)) {
            FileObject fo = javaOrClassFile.getParent();
            String targetPath = fpath.substring(0, fpath.length() - suffix.length());
            while (!fo.getPath().equals(targetPath)) {
                fo = fo.getParent();
            }
            return fo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject findClassPackage(FileObject file) {
        block6: {
            FileObject fileObject;
            InputStream in = file.getInputStream();
            try {
                ClassFile cf = new ClassFile(in, false);
                ClassName cn = cf.getName();
                fileObject = JavadocAndSourceRootDetection.getPackageRoot(file, cn.getPackage());
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (FileNotFoundException fnf) {
                    break block6;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            in.close();
            return fileObject;
        }
        return null;
    }

    static {
        String whitespace = "(?:(?://[^\n]*\n)|(?:/\\*.*?\\*/)|\\s)";
        String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
        String packageStatement = "package" + whitespace + "+(" + javaIdentifier + "(?:\\." + javaIdentifier + ")*)" + whitespace + "*;";
        JAVA_FILE = Pattern.compile("(?ms)" + whitespace + "*" + packageStatement + ".*", 40);
        PACKAGE_INFO = Pattern.compile("(?ms)(?:.*" + whitespace + ")?" + packageStatement + whitespace + "*", 40);
    }
}

