/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class MakeSharableVisualPanel1
extends JPanel {
    private AntProjectHelper helper;
    private ChangeSupport support;
    private WizardDescriptor settings;
    private DocumentListener docListener;
    private JButton btnDefinition;
    private JLabel lblDefinition;
    private JLabel lblNote;
    private JTextField txtDefinition;

    public MakeSharableVisualPanel1(ChangeSupport supp) {
        this.initComponents();
        this.support = supp;
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MakeSharableVisualPanel1.this.support.fireChange();
            }
        };
        this.txtDefinition.getDocument().addDocumentListener(this.docListener);
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"TIT_LibraryDefinitionSelection");
    }

    boolean isValidPanel() {
        String location = this.getLibraryLocation();
        boolean wrong = false;
        if (new File(location).isAbsolute()) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"WARN_MakeSharable.absolutePath"));
            wrong = true;
        } else {
            File libLoc;
            File projectLoc = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
            if (!CollocationQuery.areCollocated((File)projectLoc, (File)(libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location)))) {
                this.settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"WARN_makeSharable.relativePath"));
                wrong = true;
            }
        }
        if (!wrong) {
            this.settings.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    private String getLibraryLocation() {
        return this.txtDefinition.getText().trim();
    }

    private void setLibraryLocation(String loc) {
        this.txtDefinition.setText(loc);
    }

    void readSettings(WizardDescriptor wiz) {
        this.settings = wiz;
        String loc = (String)wiz.getProperty("location");
        this.helper = (AntProjectHelper)wiz.getProperty("helper");
        loc = loc == null ? "." + File.separator + "lib" : loc.substring(0, loc.length() - "nblibraries.properties".length());
        this.setLibraryLocation(loc);
        this.support.fireChange();
    }

    void storeSettings(WizardDescriptor wiz) {
        String librariesDefinition = this.getLibraryLocation();
        if (librariesDefinition != null) {
            if (librariesDefinition.length() != 0 && !librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + "nblibraries.properties";
        }
        wiz.putProperty("location", (Object)librariesDefinition);
    }

    private void initComponents() {
        this.lblDefinition = new JLabel();
        this.txtDefinition = new JTextField();
        this.btnDefinition = new JButton();
        this.lblNote = new JLabel();
        this.lblDefinition.setLabelFor(this.txtDefinition);
        Mnemonics.setLocalizedText((JLabel)this.lblDefinition, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.lblDefinition.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDefinition, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.btnDefinition.text"));
        this.btnDefinition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakeSharableVisualPanel1.this.btnDefinitionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblNote, (String)NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"MakeSharableVisualPanel1.lblNote.text"));
        this.lblNote.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblDefinition).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNote, -1, 365, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.txtDefinition, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDefinition)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDefinition).addComponent(this.lblDefinition).addComponent(this.txtDefinition, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNote, -2, 129, -2).addContainerGap(116, Short.MAX_VALUE)));
        this.lblDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_lblDefinition"));
        this.txtDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_lblDefinition"));
        this.btnDefinition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel1.class, (String)"ACSD_btnDefinition"));
    }

    private void btnDefinitionActionPerformed(ActionEvent evt) {
        File f = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
        String curr = SharableLibrariesUtils.browseForLibraryLocation(this.getLibraryLocation(), this, f);
        if (curr != null) {
            this.setLibraryLocation(curr);
        }
    }
}

