/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DesignComponentDataFlavorSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.common.PropertiesSupport;
import org.netbeans.modules.vmd.inspector.InspectorChildren;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.datatransfer.PasteType;

final class InspectorFolderNode
extends AbstractNode {
    private static final Action[] EMPTY_ACTION_ARRAY = new Action[0];
    private static DataFlavor INSPECTOR_NODE_DATA_FLAVOR = new DataFlavor(NodeTransferable.class, "Nodetransferable");
    private Long componentID;
    private WeakReference<DesignComponent> component;
    private InspectorFolder folder;
    private Transferable transferable;

    InspectorFolderNode(DataObjectContext context) {
        super((Children)new InspectorChildren(), context.getDataObject().getLookup());
    }

    InspectorFolderNode() {
        super((Children)new InspectorChildren());
    }

    Long getComponentID() {
        return this.componentID;
    }

    public String getHtmlDisplayName() {
        if (this.component == null || this.component.get() == null || this.getComponent() == null || this.getComponent().getDocument() == null) {
            return "";
        }
        final String[] componentTypeName = new String[1];
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                InfoPresenter presenter = (InfoPresenter)InspectorFolderNode.this.getComponent().getPresenter(InfoPresenter.class);
                componentTypeName[0] = presenter.getDisplayName(InfoPresenter.NameType.SECONDARY);
            }
        });
        String name = this.getName();
        if (this.getName() != null && this.getName().contains("<")) {
            name = this.getName().replace("<", "&lt;").replace(">", "&gt;");
        }
        return componentTypeName[0] != null ? name + " <font color=\"#808080\">[" + componentTypeName[0] + "]" : name;
    }

    public Image getIcon(int type) {
        if (this.folder == null) {
            throw new IllegalStateException("Not resolved Folder- Broken tree structure. Check InspectorPosisitonPresenters and InspectorFolderPresenters");
        }
        return this.folder.getIcon();
    }

    public Image getOpenedIcon(int type) {
        return this.folder.getIcon();
    }

    public Action[] getActions(boolean context) {
        if (this.folder.getActions() == null) {
            return EMPTY_ACTION_ARRAY;
        }
        return this.folder.getActions();
    }

    public boolean canRename() {
        return false;
    }

    public AcceptSuggestion createSuggestion(Transferable transferable) {
        return this.folder.createSuggestion(transferable);
    }

    public void setName(final String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name cant be null");
        }
        if (this.component == null) {
            return;
        }
        DesignComponent c = (DesignComponent)this.component.get();
        if (c == null) {
            return;
        }
        c.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                InfoPresenter presenter = (InfoPresenter)((DesignComponent)InspectorFolderNode.this.component.get()).getPresenter(InfoPresenter.class);
                if (presenter != null) {
                    presenter.setEditableName(name);
                }
            }
        });
    }

    void resolveNode(final InspectorFolderWrapper folderWrapper, final DesignDocument document) {
        this.folder = folderWrapper.getFolder();
        super.setDisplayName(this.folder.getDisplayName());
        this.componentID = this.folder.getComponentID();
        if (this.folder.getName() == null) {
            super.setName(this.folder.getDisplayName());
        } else {
            super.setName(this.folder.getName());
        }
        if (this.componentID != null) {
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    InspectorFolderNode.this.component = new WeakReference<DesignComponent>(document.getComponentByUID(InspectorFolderNode.this.componentID.longValue()));
                    InspectorFolderNode.this.transferable = new NodeTransferable((DesignComponent)InspectorFolderNode.this.component.get());
                }
            });
        }
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                ((InspectorChildren)InspectorFolderNode.this.getChildren()).setKeys(folderWrapper.getChildrenNodes());
            }
        });
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        if (!t.isDataFlavorSupported(INSPECTOR_NODE_DATA_FLAVOR)) {
            return;
        }
        PasteType paste = this.getDropType(t, 3, -1);
        if (paste != null) {
            s.add(paste);
        }
    }

    public PasteType getDropType(final Transferable t, int action, int index) {
        final PasteType[] pasteType = new PasteType[1];
        if (!t.isDataFlavorSupported(INSPECTOR_NODE_DATA_FLAVOR)) {
            return null;
        }
        if (this.component == null) {
            return null;
        }
        DesignComponent c = (DesignComponent)this.component.get();
        if (c == null) {
            return null;
        }
        c.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                final AcceptSuggestion suggestion = InspectorFolderNode.this.createSuggestion(t);
                if (InspectorFolderNode.this.component.get() != null && AcceptSupport.isAcceptable((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)t, (AcceptSuggestion)suggestion)) {
                    pasteType[0] = new PasteType(){

                        public Transferable paste() throws IOException {
                            ((DesignComponent)InspectorFolderNode.this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    if (InspectorFolderNode.this.component.get() != null && AcceptSupport.isAcceptable((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)t, (AcceptSuggestion)suggestion)) {
                                        AcceptSupport.accept((DesignComponent)((DesignComponent)InspectorFolderNode.this.component.get()), (Transferable)t, null);
                                    }
                                }
                            });
                            return t;
                        }
                    };
                }
            }
        });
        return pasteType[0];
    }

    public Transferable drag() throws IOException {
        return this.transferable;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        return this.transferable;
    }

    public Transferable clipboardCut() throws IOException {
        return this.transferable;
    }

    public boolean canDestroy() {
        return true;
    }

    DesignComponent getComponent() {
        return this.component == null ? null : (DesignComponent)this.component.get();
    }

    void terminate() {
        this.componentID = null;
        this.component = null;
        this.folder = null;
    }

    public Sheet createSheet() {
        DataEditorView view;
        if (this.component == null) {
            return super.createSheet();
        }
        DesignComponent c = (DesignComponent)this.component.get();
        if (c == null) {
            return super.createSheet();
        }
        if (c == null) {
            super.createSheet();
        }
        if ((view = ActiveViewSupport.getDefault().getActiveView()) != null && view.getKind() == DataEditorView.Kind.MODEL) {
            return PropertiesSupport.getSheet((DataEditorView)view, (DesignComponent)c);
        }
        return super.createSheet();
    }

    private class NodeTransferable
    implements Transferable {
        private WeakReference<DesignComponent> component;

        public NodeTransferable(DesignComponent component) {
            assert (component != null);
            this.component = new WeakReference<DesignComponent>(component);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR, INSPECTOR_NODE_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor == DesignComponentDataFlavorSupport.DESIGN_COMPONENT_DATA_FLAVOR) {
                return true;
            }
            return flavor == INSPECTOR_NODE_DATA_FLAVOR;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.component.get();
        }
    }
}

