/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.versioning.shelve.ShelveChangesPanel;
import org.netbeans.modules.versioning.shelve.impl.PatchStorage;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class ShelveChangesSupport {
    private String patchName;
    private static final Pattern PATCH_NAME_PATTERN = Pattern.compile("^(.*)-(\\d+)$");

    protected abstract void exportPatch(File var1, File var2) throws IOException;

    protected abstract void postExportCleanup();

    protected abstract boolean isCanceled();

    public final boolean prepare() {
        return this.openDialog() && this.patchName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shelveChanges(File[] roots) {
        assert (!EventQueue.isDispatchThread());
        if (this.patchName == null) {
            throw new IllegalStateException("Patch name not initialized, you probably forgot to run prepare()");
        }
        PatchStorage storage = PatchStorage.getInstance();
        File commonParent = ShelveChangesSupport.getCommonParent(roots);
        File patchFile = storage.reservePatchFile(this.patchName);
        boolean patchCreated = false;
        try {
            if (this.isCanceled()) {
                return;
            }
            this.exportPatch(patchFile, commonParent);
            if (!patchFile.exists() || this.isCanceled()) {
                return;
            }
            patchCreated = true;
            storage.savePatchInfo(this.patchName, patchFile, commonParent);
            this.postExportCleanup();
        }
        catch (IOException ex) {
            Logger.getLogger(ShelveChangesSupport.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            if (!patchCreated) {
                storage.dismissPatchFile(patchFile);
            }
        }
    }

    private static File getCommonParent(File[] files) {
        File root = files[0];
        if (!root.exists() || root.isFile()) {
            root = root.getParentFile();
        }
        for (int i = 1; i < files.length; ++i) {
            if ((root = Utils.getCommonParent(root, files[i])) != null) continue;
            return null;
        }
        return root;
    }

    private boolean openDialog() {
        ShelveChangesPanel panel = new ShelveChangesPanel();
        this.initializePatchName(panel.txtPatchName);
        panel.lblError.setVisible(false);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(ShelveChangesSupport.class, (String)"CTL_ShelveChangesPanel.okButton.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ShelveChangesSupport.class, (String)"LBL_ShelveChangesPanel.title"), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(ShelveChangesPanel.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        panel.txtPatchName.getDocument().addDocumentListener(new PatchNameListener(panel, okButton, dialog));
        dialog.setVisible(true);
        if (dd.getValue() == okButton) {
            this.patchName = panel.txtPatchName.getText().trim();
            return !this.patchName.isEmpty();
        }
        return false;
    }

    private void initializePatchName(final JTextField tf) {
        Utils.postParallel(new Runnable(){

            @Override
            public void run() {
                String offeredPatchName;
                List<String> patchNames = PatchStorage.getInstance().getPatchNames();
                String originalPatchName = offeredPatchName = patchNames.isEmpty() ? "unfinishedChanges" : patchNames.get(0);
                int i = 0;
                Matcher m = PATCH_NAME_PATTERN.matcher(offeredPatchName);
                if (m.matches()) {
                    try {
                        i = Integer.parseInt(m.group(2));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    originalPatchName = m.group(1);
                    offeredPatchName = originalPatchName + "-" + ++i;
                }
                while (patchNames.contains(offeredPatchName)) {
                    offeredPatchName = originalPatchName + "-" + ++i;
                }
                final String patchName = offeredPatchName;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (tf.getText().isEmpty()) {
                            tf.setText(patchName);
                            tf.selectAll();
                        }
                    }
                });
            }
        }, 0);
    }

    private static class PatchNameListener
    implements DocumentListener,
    ActionListener {
        private final JButton button;
        private final Timer timer;
        private final ShelveChangesPanel panel;
        private final Dialog dialog;
        private static final Pattern p = Pattern.compile("\\s+");

        private PatchNameListener(ShelveChangesPanel panel, JButton okButton, Dialog dialog) {
            this.panel = panel;
            this.button = okButton;
            this.dialog = dialog;
            this.timer = new Timer(300, this);
            this.timer.stop();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void update() {
            this.button.setEnabled(false);
            this.panel.lblError.setVisible(false);
            this.timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String patchName = this.panel.txtPatchName.getText().trim();
            if (!patchName.isEmpty()) {
                if (p.matcher(patchName).find()) {
                    this.setError(NbBundle.getMessage(ShelveChangesPanel.class, (String)"ShelveChangesPanel.lblError.spaces"));
                } else if (!PatchStorage.getInstance().containsPatch(patchName)) {
                    this.button.setEnabled(true);
                } else {
                    this.setError(NbBundle.getMessage(ShelveChangesPanel.class, (String)"ShelveChangesPanel.lblError.text"));
                    if (this.dialog.getHeight() < this.dialog.getPreferredSize().height || this.dialog.getWidth() < this.dialog.getPreferredSize().width) {
                        this.dialog.pack();
                    }
                }
            }
        }

        private void setError(String msg) {
            this.panel.lblError.setText(msg);
            this.panel.lblError.setVisible(true);
        }
    }
}

