/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.shelve.impl;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.shelve.impl.PatchStorage;
import org.netbeans.modules.versioning.shelve.impl.UnshelveChangesPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class UnshelveChangesAction
extends AbstractAction {
    private final String defaultPatchName;

    public UnshelveChangesAction() {
        this.defaultPatchName = null;
    }

    public UnshelveChangesAction(String patchName) {
        super(NbBundle.getMessage(UnshelveChangesAction.class, (String)"CTL_MenuItem_UnshelveChanges.patch", (Object)patchName));
        this.defaultPatchName = patchName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        boolean removePatchFile;
        String patchName;
        if (this.defaultPatchName == null) {
            Unshelve unshelve = new Unshelve();
            if (!unshelve.selectPatchName()) return;
            patchName = unshelve.getPatchName();
            removePatchFile = unshelve.getRemovePatchFile();
        } else {
            patchName = this.defaultPatchName;
            removePatchFile = true;
        }
        final PatchStorage storage = PatchStorage.getInstance();
        Utils.post(new Runnable(){

            @Override
            public void run() {
                PatchStorage.Patch patch = storage.getPatch(patchName);
                if (patch != null && PatchAction.performPatch((File)patch.getPatchFile(), (File)patch.getPatchContext())) {
                    storage.removePatch(patchName, removePatchFile);
                }
            }
        });
    }

    private static class Unshelve
    implements ActionListener {
        private final JButton unshelveButton;
        private final JButton removeButton;
        private final UnshelveChangesPanel panel = new UnshelveChangesPanel();
        private String patchName;
        private boolean removePatchFile;
        private static final String LOADING_PATCHES = NbBundle.getMessage(UnshelveChangesAction.class, (String)"LBL_UnshelveChangesPanel.loading");

        public Unshelve() {
            this.panel.cmbPatches.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value instanceof PatchStorage.Patch) {
                        value = ((PatchStorage.Patch)value).getPatchName();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            this.unshelveButton = new JButton();
            this.removeButton = new JButton();
            this.panel.cmbPatches.addActionListener(this);
            this.initializePatches();
        }

        public boolean selectPatchName() {
            Mnemonics.setLocalizedText((AbstractButton)this.unshelveButton, (String)NbBundle.getMessage(UnshelveChangesAction.class, (String)"CTL_UnshelveChangesPanel.unshelveButton.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(UnshelveChangesAction.class, (String)"CTL_UnshelveChangesPanel.removeButton.text"));
            DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(UnshelveChangesAction.class, (String)"LBL_UnshelveChangesPanel.title"), true, new Object[]{this.unshelveButton, this.removeButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.unshelveButton, 0, new HelpCtx(UnshelveChangesAction.class), null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            this.patchName = this.panel.cmbPatches.getSelectedItem() instanceof PatchStorage.Patch ? ((PatchStorage.Patch)this.panel.cmbPatches.getSelectedItem()).getPatchName().trim() : null;
            boolean bl = this.removePatchFile = !this.panel.cbKeepPatchFile.isSelected();
            if (this.patchName == null) {
                return false;
            }
            if (dd.getValue() == this.unshelveButton) {
                return true;
            }
            if (dd.getValue() == this.removeButton) {
                Utils.post(new Runnable(){

                    @Override
                    public void run() {
                        PatchStorage.getInstance().removePatch(Unshelve.this.patchName, Unshelve.this.removePatchFile);
                    }
                });
            }
            return false;
        }

        private String getPatchName() {
            return this.patchName;
        }

        private boolean getRemovePatchFile() {
            return this.removePatchFile;
        }

        private void initializePatches() {
            this.panel.cmbPatches.setModel(new DefaultComboBoxModel<String>(new String[]{LOADING_PATCHES}));
            this.validate();
            Utils.postParallel(new Runnable(){

                @Override
                public void run() {
                    final List<PatchStorage.Patch> patches = PatchStorage.getInstance().getPatches();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((Unshelve)Unshelve.this).panel.cmbPatches.setModel(new DefaultComboBoxModel<PatchStorage.Patch>(patches.toArray(new PatchStorage.Patch[patches.size()])));
                            if (!patches.isEmpty()) {
                                ((Unshelve)Unshelve.this).panel.cmbPatches.setSelectedIndex(0);
                            }
                        }
                    });
                }
            }, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validate();
        }

        private void validate() {
            if (this.panel.cmbPatches.getSelectedItem() instanceof PatchStorage.Patch) {
                this.removeButton.setEnabled(true);
                this.unshelveButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
                this.unshelveButton.setEnabled(false);
            }
        }
    }
}

