/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.openide.util.NbBundle;

public class GitException
extends Exception {
    public GitException(Throwable t) {
        super(t);
    }

    public GitException(String message) {
        super(message);
    }

    public GitException(String message, Throwable ex) {
        super(message, ex);
    }

    public static class NotMergedException
    extends GitException {
        private final String unmergedRevision;

        public NotMergedException(String unmergedRevision) {
            super(unmergedRevision + " has not been fully merged yet");
            this.unmergedRevision = unmergedRevision;
        }

        public String getUnmergedRevision() {
            return this.unmergedRevision;
        }
    }

    public static class RefUpdateException
    extends GitException {
        private final GitRefUpdateResult result;

        public RefUpdateException(String message, GitRefUpdateResult result) {
            super(message);
            this.result = result;
        }

        public GitRefUpdateResult getResult() {
            return this.result;
        }
    }

    public static class AuthorizationException
    extends GitException {
        private final String repositoryUrl;

        public AuthorizationException(String repositoryUrl, String message, Throwable t) {
            super(message, t);
            this.repositoryUrl = repositoryUrl;
        }

        public AuthorizationException(String message, Throwable t) {
            this(null, message, t);
        }

        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }
    }

    public static class CheckoutConflictException
    extends GitException {
        private final String[] conflicts;

        public CheckoutConflictException(String[] conflicts, Throwable cause) {
            super(NbBundle.getMessage(GitException.class, (String)"MSG_Exception_CheckoutConflicts"), cause);
            this.conflicts = conflicts;
        }

        public CheckoutConflictException(String[] conflicts) {
            this(conflicts, null);
        }

        public String[] getConflicts() {
            return this.conflicts;
        }
    }

    public static class MissingObjectException
    extends GitException {
        private final String objectName;
        private final GitObjectType objectType;

        public MissingObjectException(String objectName, GitObjectType objectType) {
            super(NbBundle.getMessage(GitException.class, (String)"MSG_Exception_ObjectDoesNotExist", (Object[])new Object[]{objectType.toString(), objectName}));
            this.objectName = objectName;
            this.objectType = objectType;
        }

        public MissingObjectException(String objectName, GitObjectType objectType, Throwable ex) {
            super(NbBundle.getMessage(GitException.class, (String)"MSG_Exception_ObjectDoesNotExist", (Object[])new Object[]{objectType.toString(), objectName}), ex);
            this.objectName = objectName;
            this.objectType = objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public GitObjectType getObjectType() {
            return this.objectType;
        }
    }
}

