/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.jgit.JGitCredentialsProvider;
import org.netbeans.libs.git.jgit.JGitRepository;
import org.netbeans.libs.git.jgit.JGitUserInfo;
import org.netbeans.libs.git.jgit.commands.AddCommand;
import org.netbeans.libs.git.jgit.commands.BlameCommand;
import org.netbeans.libs.git.jgit.commands.CatCommand;
import org.netbeans.libs.git.jgit.commands.CheckoutIndexCommand;
import org.netbeans.libs.git.jgit.commands.CheckoutRevisionCommand;
import org.netbeans.libs.git.jgit.commands.CleanCommand;
import org.netbeans.libs.git.jgit.commands.CommitCommand;
import org.netbeans.libs.git.jgit.commands.ConflictCommand;
import org.netbeans.libs.git.jgit.commands.CopyCommand;
import org.netbeans.libs.git.jgit.commands.CreateBranchCommand;
import org.netbeans.libs.git.jgit.commands.CreateTagCommand;
import org.netbeans.libs.git.jgit.commands.DeleteBranchCommand;
import org.netbeans.libs.git.jgit.commands.DeleteTagCommand;
import org.netbeans.libs.git.jgit.commands.ExportCommitCommand;
import org.netbeans.libs.git.jgit.commands.ExportDiffCommand;
import org.netbeans.libs.git.jgit.commands.FetchCommand;
import org.netbeans.libs.git.jgit.commands.GetCommonAncestorCommand;
import org.netbeans.libs.git.jgit.commands.GetPreviousCommitCommand;
import org.netbeans.libs.git.jgit.commands.GetRemotesCommand;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.IgnoreCommand;
import org.netbeans.libs.git.jgit.commands.InitRepositoryCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.jgit.commands.ListModifiedIndexEntriesCommand;
import org.netbeans.libs.git.jgit.commands.ListRemoteBranchesCommand;
import org.netbeans.libs.git.jgit.commands.ListRemoteTagsCommand;
import org.netbeans.libs.git.jgit.commands.ListTagCommand;
import org.netbeans.libs.git.jgit.commands.LogCommand;
import org.netbeans.libs.git.jgit.commands.MergeCommand;
import org.netbeans.libs.git.jgit.commands.PullCommand;
import org.netbeans.libs.git.jgit.commands.PushCommand;
import org.netbeans.libs.git.jgit.commands.RemoveCommand;
import org.netbeans.libs.git.jgit.commands.RemoveRemoteCommand;
import org.netbeans.libs.git.jgit.commands.RenameCommand;
import org.netbeans.libs.git.jgit.commands.ResetCommand;
import org.netbeans.libs.git.jgit.commands.RevertCommand;
import org.netbeans.libs.git.jgit.commands.SetRemoteCommand;
import org.netbeans.libs.git.jgit.commands.StatusCommand;
import org.netbeans.libs.git.jgit.commands.UnignoreCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;
import org.netbeans.libs.git.progress.StatusListener;

public class JGitClient
implements GitClient,
StatusListener,
FileListener,
RevisionInfoListener {
    private final JGitRepository gitRepository;
    private final Set<NotificationListener> listeners;
    private JGitCredentialsProvider credentialsProvider;

    public JGitClient(JGitRepository gitRepository) {
        this.gitRepository = gitRepository;
        this.listeners = new HashSet<NotificationListener>();
    }

    @Override
    public void add(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        AddCommand cmd = new AddCommand(repository, roots, monitor, this);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    @Override
    public GitBlameResult blame(File file, String revision, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        BlameCommand cmd = new BlameCommand(repository, file, revision, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    @Override
    public boolean catFile(File file, String revision, OutputStream out, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        CatCommand cmd = new CatCommand(repository, file, revision, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    @Override
    public boolean catIndexEntry(File file, int stage, OutputStream out, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CatCommand cmd = new CatCommand(repository, file, stage, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    @Override
    public void checkout(File[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitCommand cmd;
        Repository repository = this.gitRepository.getRepository();
        if (revision != null) {
            cmd = new ResetCommand(repository, revision, roots, recursively, monitor, this);
            cmd.execute();
        }
        if (!monitor.isCanceled()) {
            cmd = new CheckoutIndexCommand(repository, roots, recursively, monitor, this);
            cmd.execute();
        }
    }

    @Override
    public void checkoutRevision(String revision, boolean failOnConflict, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        if (!failOnConflict) {
            throw new IllegalArgumentException("Currently unsupported. failOnConflict must be set to true. JGit lib is buggy.");
        }
        Repository repository = this.gitRepository.getRepository();
        CheckoutRevisionCommand cmd = new CheckoutRevisionCommand(repository, revision, failOnConflict, monitor, this);
        cmd.execute();
    }

    @Override
    public void clean(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CleanCommand cmd = new CleanCommand(repository, roots, monitor, this);
        cmd.execute();
    }

    @Override
    public GitRevisionInfo commit(File[] roots, String commitMessage, GitUser author, GitUser commiter, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CommitCommand cmd = new CommitCommand(repository, roots, commitMessage, author, commiter, monitor);
        cmd.execute();
        return cmd.revision;
    }

    @Override
    public void copyAfter(File source, File target, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CopyCommand cmd = new CopyCommand(repository, source, target, monitor, this);
        cmd.execute();
    }

    @Override
    public GitBranch createBranch(String branchName, String revision, ProgressMonitor monitor) throws GitException {
        CreateBranchCommand cmd = new CreateBranchCommand(this.gitRepository.getRepository(), branchName, revision, monitor);
        cmd.execute();
        return cmd.getBranch();
    }

    @Override
    public GitTag createTag(String tagName, String taggedObjectId, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) throws GitException.RefUpdateException, GitException {
        CreateTagCommand cmd = new CreateTagCommand(this.gitRepository.getRepository(), tagName, taggedObjectId, message, signed, forceUpdate, monitor);
        cmd.execute();
        return cmd.getTag();
    }

    @Override
    public void deleteBranch(String branchName, boolean forceDeleteUnmerged, ProgressMonitor monitor) throws GitException.NotMergedException, GitException {
        DeleteBranchCommand cmd = new DeleteBranchCommand(this.gitRepository.getRepository(), branchName, forceDeleteUnmerged, monitor);
        cmd.execute();
    }

    @Override
    public void deleteTag(String tagName, ProgressMonitor monitor) throws GitException.RefUpdateException, GitException {
        DeleteTagCommand cmd = new DeleteTagCommand(this.gitRepository.getRepository(), tagName, monitor);
        cmd.execute();
    }

    @Override
    public void exportCommit(String commit, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportCommitCommand cmd = new ExportCommitCommand(this.gitRepository.getRepository(), commit, out, monitor, this);
        cmd.execute();
    }

    @Override
    public void exportDiff(File[] roots, GitClient.DiffMode mode, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportDiffCommand cmd = new ExportDiffCommand(this.gitRepository.getRepository(), roots, mode, out, monitor, this);
        cmd.execute();
    }

    @Override
    public Map<String, GitTransportUpdate> fetch(String remote, ProgressMonitor monitor) throws GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository.getRepository(), remote, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getUpdates();
    }

    @Override
    public Map<String, GitTransportUpdate> fetch(String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository.getRepository(), remote, fetchRefSpecifications, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getUpdates();
    }

    @Override
    public Map<String, GitBranch> getBranches(boolean all, ProgressMonitor monitor) throws GitException {
        ListBranchCommand cmd = new ListBranchCommand(this.gitRepository.getRepository(), all, monitor);
        cmd.execute();
        return cmd.getBranches();
    }

    @Override
    public Map<String, GitTag> getTags(ProgressMonitor monitor, boolean all) throws GitException {
        ListTagCommand cmd = new ListTagCommand(this.gitRepository.getRepository(), all, monitor);
        cmd.execute();
        return cmd.getTags();
    }

    @Override
    public GitRevisionInfo getCommonAncestor(String[] revisions, ProgressMonitor monitor) throws GitException {
        GetCommonAncestorCommand cmd = new GetCommonAncestorCommand(this.gitRepository.getRepository(), revisions, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    @Override
    public GitRevisionInfo getPreviousRevision(File file, String revision, ProgressMonitor monitor) throws GitException {
        GetPreviousCommitCommand cmd = new GetPreviousCommitCommand(this.gitRepository.getRepository(), file, revision, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    @Override
    public Map<File, GitStatus> getConflicts(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ConflictCommand cmd = new ConflictCommand(repository, roots, monitor, this);
        cmd.execute();
        return cmd.getStatuses();
    }

    @Override
    public Map<File, GitStatus> getStatus(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        StatusCommand cmd = new StatusCommand(repository, roots, monitor, this);
        cmd.execute();
        return cmd.getStatuses();
    }

    @Override
    public GitRemoteConfig getRemote(String remoteName, ProgressMonitor monitor) throws GitException {
        return this.getRemotes(monitor).get(remoteName);
    }

    @Override
    public Map<String, GitRemoteConfig> getRemotes(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        GetRemotesCommand cmd = new GetRemotesCommand(repository, monitor);
        cmd.execute();
        return cmd.getRemotes();
    }

    @Override
    public GitRepositoryState getRepositoryState(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RepositoryState state = repository.getRepositoryState();
        switch (state) {
            case APPLY: {
                return GitRepositoryState.APPLY;
            }
            case BARE: {
                return GitRepositoryState.BARE;
            }
            case BISECTING: {
                return GitRepositoryState.BISECTING;
            }
            case MERGING: {
                return GitRepositoryState.MERGING;
            }
            case MERGING_RESOLVED: {
                return GitRepositoryState.MERGING_RESOLVED;
            }
            case REBASING: 
            case REBASING_INTERACTIVE: 
            case REBASING_MERGE: 
            case REBASING_REBASING: {
                return GitRepositoryState.REBASING;
            }
            case SAFE: {
                return GitRepositoryState.SAFE;
            }
        }
        throw new IllegalStateException(state.getDescription());
    }

    @Override
    public File[] ignore(File[] files, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        IgnoreCommand cmd = new IgnoreCommand(repository, files, monitor, this);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    @Override
    public void init(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        InitRepositoryCommand cmd = new InitRepositoryCommand(repository, monitor);
        cmd.execute();
    }

    @Override
    public File[] listModifiedIndexEntries(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ListModifiedIndexEntriesCommand cmd = new ListModifiedIndexEntriesCommand(repository, roots, monitor, this);
        cmd.execute();
        return cmd.getFiles();
    }

    @Override
    public Map<String, GitBranch> listRemoteBranches(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ListRemoteBranchesCommand cmd = new ListRemoteBranchesCommand(repository, remoteRepositoryUrl, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getBranches();
    }

    @Override
    public Map<String, String> listRemoteTags(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ListRemoteTagsCommand cmd = new ListRemoteTagsCommand(repository, remoteRepositoryUrl, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getTags();
    }

    @Override
    public GitRevisionInfo log(String revision, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        LogCommand cmd = new LogCommand(repository, revision, monitor, (RevisionInfoListener)this);
        cmd.execute();
        GitRevisionInfo[] revisions = cmd.getRevisions();
        return revisions.length == 0 ? null : revisions[0];
    }

    @Override
    public GitRevisionInfo[] log(SearchCriteria searchCriteria, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        LogCommand cmd = new LogCommand(repository, searchCriteria, monitor, (RevisionInfoListener)this);
        cmd.execute();
        return cmd.getRevisions();
    }

    @Override
    public GitMergeResult merge(String revision, ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        Repository repository = this.gitRepository.getRepository();
        MergeCommand cmd = new MergeCommand(repository, revision, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    @Override
    public GitPullResult pull(String remote, List<String> fetchRefSpecifications, String branchToMerge, ProgressMonitor monitor) throws GitException {
        PullCommand cmd = new PullCommand(this.gitRepository.getRepository(), remote, fetchRefSpecifications, branchToMerge, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getResult();
    }

    @Override
    public GitPushResult push(String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException {
        PushCommand cmd = new PushCommand(this.gitRepository.getRepository(), remote, pushRefSpecifications, fetchRefSpecifications, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getResult();
    }

    @Override
    public void remove(File[] roots, boolean cached, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RemoveCommand cmd = new RemoveCommand(repository, roots, cached, monitor, this);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void removeRemote(String remote, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RemoveRemoteCommand cmd = new RemoveRemoteCommand(repository, remote, monitor);
        cmd.execute();
    }

    @Override
    public void rename(File source, File target, boolean after, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RenameCommand cmd = new RenameCommand(repository, source, target, after, monitor, this);
        cmd.execute();
    }

    @Override
    public void reset(File[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ResetCommand cmd = new ResetCommand(repository, revision, roots, recursively, monitor, this);
        cmd.execute();
    }

    @Override
    public void reset(String revision, GitClient.ResetType resetType, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ResetCommand cmd = new ResetCommand(repository, revision, resetType, monitor, this);
        cmd.execute();
    }

    @Override
    public GitRevertResult revert(String revision, String message, boolean commit, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        RevertCommand cmd = new RevertCommand(repository, revision, message, commit, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    @Override
    public void setCallback(GitClientCallback callback) {
        this.credentialsProvider = callback == null ? null : new JGitCredentialsProvider(callback);
    }

    @Override
    public void setRemote(GitRemoteConfig remoteConfig, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        SetRemoteCommand cmd = new SetRemoteCommand(repository, remoteConfig, monitor, this);
        cmd.execute();
    }

    @Override
    public GitUser getUser() throws GitException {
        return new JGitUserInfo(new PersonIdent(this.gitRepository.getRepository()));
    }

    @Override
    public File[] unignore(File[] files, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        UnignoreCommand cmd = new UnignoreCommand(repository, files, monitor, this);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFile(File file, String relativePathToRoot) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof FileListener)) continue;
            ((FileListener)list).notifyFile(file, relativePathToRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStatus(GitStatus status) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof StatusListener)) continue;
            ((StatusListener)list).notifyStatus(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRevisionInfo(GitRevisionInfo info) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof RevisionInfoListener)) continue;
            ((RevisionInfoListener)list).notifyRevisionInfo(info);
        }
    }
}

