/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.jgit.JGitRevisionInfo;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public class CommitCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final String message;
    private final GitUser author;
    private final GitUser commiter;
    public GitRevisionInfo revision;

    public CommitCommand(Repository repository, File[] roots, String message, GitUser author, GitUser commiter, ProgressMonitor monitor) {
        super(repository, monitor);
        this.roots = roots;
        this.message = message;
        this.monitor = monitor;
        this.author = author;
        this.commiter = commiter;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            RepositoryState state = this.getRepository().getRepositoryState();
            if (RepositoryState.MERGING.equals((Object)state)) {
                String errorMessage = NbBundle.getMessage(CommitCommand.class, (String)"MSG_Error_Commit_ConflictsInIndex");
                this.monitor.preparationsFailed(errorMessage);
                throw new GitException(errorMessage);
            }
            if (RepositoryState.MERGING_RESOLVED.equals((Object)state) && this.roots.length > 0) {
                boolean fullWorkingTree = false;
                File repositoryRoot = this.getRepository().getWorkTree();
                for (File root : this.roots) {
                    if (!root.equals(repositoryRoot)) continue;
                    fullWorkingTree = true;
                    break;
                }
                if (!fullWorkingTree) {
                    String errorMessage = NbBundle.getMessage(CommitCommand.class, (String)"MSG_Error_Commit_PartialCommitAfterMerge");
                    this.monitor.preparationsFailed(errorMessage);
                    throw new GitException(errorMessage);
                }
            } else if (!state.canCommit()) {
                String errorMessage = NbBundle.getMessage(CommitCommand.class, (String)"MSG_Error_Commit_NotAllowedInCurrentState");
                this.monitor.preparationsFailed(errorMessage);
                throw new GitException(errorMessage);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache backup = repository.readDirCache();
            try {
                this.prepareIndex();
                org.eclipse.jgit.api.CommitCommand commit = new Git(repository).commit();
                if (this.author != null) {
                    commit.setAuthor(this.author.getName(), this.author.getEmailAddress());
                } else {
                    commit.setAuthor(new PersonIdent(repository));
                }
                if (this.commiter != null) {
                    commit.setCommitter(this.commiter.getName(), this.commiter.getEmailAddress());
                }
                commit.setMessage(this.message);
                RevCommit rev = commit.call();
                this.revision = new JGitRevisionInfo(rev, repository);
            }
            finally {
                backup.lock();
                try {
                    backup.write();
                    backup.commit();
                }
                finally {
                    backup.unlock();
                }
            }
        }
        catch (NoHeadException ex) {
            throw new GitException(ex);
        }
        catch (NoMessageException ex) {
            throw new GitException(ex);
        }
        catch (UnmergedPathException ex) {
            throw new GitException(ex);
        }
        catch (ConcurrentRefUpdateException ex) {
            throw new GitException(ex);
        }
        catch (JGitInternalException ex) {
            throw new GitException(ex);
        }
        catch (WrongRepositoryStateException ex) {
            throw new GitException(ex);
        }
        catch (NoWorkTreeException ex) {
            throw new GitException(ex);
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareIndex() throws NoWorkTreeException, CorruptObjectException, IOException {
        Repository repository = this.getRepository();
        DirCache cache = repository.lockDirCache();
        try {
            TreeWalk treeWalk = new TreeWalk(repository);
            TreeFilter filter = Utils.getExcludeExactPathsFilter(repository.getWorkTree(), this.roots);
            if (filter != null) {
                DirCacheEditor edit = cache.editor();
                treeWalk.setFilter(filter);
                treeWalk.setRecursive(true);
                treeWalk.reset();
                ObjectId headId = repository.resolve("HEAD");
                if (headId != null) {
                    treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
                } else {
                    treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                boolean T_HEAD = false;
                boolean T_INDEX = true;
                LinkedList<DirCacheEntry> toAdd = new LinkedList<DirCacheEntry>();
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    int mHead = treeWalk.getRawMode(0);
                    int mIndex = treeWalk.getRawMode(1);
                    if (mHead == FileMode.MISSING.getBits() && mIndex != FileMode.MISSING.getBits()) {
                        edit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
                        continue;
                    }
                    if ((mIndex != FileMode.MISSING.getBits() || mHead == FileMode.MISSING.getBits()) && mHead == mIndex && (mIndex == FileMode.TREE.getBits() || treeWalk.idEqual(0, 1))) continue;
                    edit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
                    DirCacheEntry e = new DirCacheEntry(path);
                    e.setFileMode(treeWalk.getFileMode(0));
                    e.setObjectId((AnyObjectId)treeWalk.getObjectId(0));
                    e.smudgeRacilyClean();
                    toAdd.add(e);
                }
                if (!this.monitor.isCanceled()) {
                    edit.finish();
                    DirCacheBuilder builder = cache.builder();
                    if (cache.getEntryCount() > 0) {
                        builder.keep(0, cache.getEntryCount());
                    }
                    for (DirCacheEntry e : toAdd) {
                        builder.add(e);
                    }
                    builder.finish();
                    builder.commit();
                }
            }
        }
        finally {
            cache.unlock();
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git commit -m ").append(this.message);
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }
}

