/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public class InitRepositoryCommand
extends GitCommand {
    private final File workDir;
    private final ProgressMonitor monitor;

    public InitRepositoryCommand(Repository repository, ProgressMonitor monitor) {
        super(repository, monitor);
        this.monitor = monitor;
        this.workDir = this.getRepository().getWorkTree();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.getRepository().getDirectory().exists();
        if (repositoryExists) {
            String message = NbBundle.getMessage(InitRepositoryCommand.class, (String)"MSG_Error_RepositoryExists", (Object)this.getRepository().getWorkTree());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        return true;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            if (!this.workDir.exists() && !this.workDir.mkdirs()) {
                throw new GitException(NbBundle.getMessage(InitRepositoryCommand.class, (String)"MSG_Exception_CannotCreateFolder", (Object)this.workDir.getAbsolutePath()));
            }
            repository.create();
        }
        catch (IllegalStateException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git init " + this.workDir.getAbsolutePath();
    }
}

