/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.JGitBranch;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ListBranchCommand
extends GitCommand {
    private final boolean all;
    private HashMap<String, GitBranch> allBranches;

    public ListBranchCommand(Repository repository, boolean all, ProgressMonitor monitor) {
        super(repository, monitor);
        this.all = all;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        Map refs = repository.getAllRefs();
        Ref head = (Ref)refs.get("HEAD");
        this.allBranches = new HashMap();
        if (head != null) {
            String current = head.getLeaf().getName();
            if (current.equals("HEAD")) {
                String name = "(no branch)";
                this.allBranches.put(name, new JGitBranch(name, false, true, head.getLeaf().getObjectId()));
            }
            this.allBranches.putAll(this.getRefs(refs.values(), "refs/heads/", false, current));
        }
        if (this.all) {
            this.allBranches.putAll(this.getRefs(refs.values(), "refs/remotes/", true, null));
        }
    }

    private Map<String, GitBranch> getRefs(Collection<Ref> allRefs, String prefix, boolean isRemote, String activeBranch) {
        HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>();
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith(prefix)) continue;
            String name = refName.substring(refName.indexOf(47, 5) + 1);
            branches.put(name, new JGitBranch(name, isRemote, refName.equals(activeBranch), ref.getLeaf().getObjectId()));
        }
        return branches;
    }

    @Override
    protected String getCommandDescription() {
        return "git branch";
    }

    public Map<String, GitBranch> getBranches() {
        return this.allBranches;
    }
}

