/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.commands.MoveTreeCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public class RenameCommand
extends MoveTreeCommand {
    final File source;
    final File target;
    final boolean after;

    public RenameCommand(Repository repository, File source, File target, boolean after, ProgressMonitor monitor, FileListener listener) {
        super(repository, source, target, after, false, monitor, listener);
        this.source = source;
        this.target = target;
        this.after = after;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            if (this.source.equals(this.getRepository().getWorkTree())) {
                throw new GitException(NbBundle.getMessage(RenameCommand.class, (String)"MSG_Exception_CannotMoveWT", (Object)this.source.getAbsolutePath()));
            }
            if (!this.source.exists() && !this.after) {
                throw new GitException(NbBundle.getMessage(RenameCommand.class, (String)"MSG_Exception_SourceDoesNotExist", (Object)this.source.getAbsolutePath()));
            }
            if (this.target.exists()) {
                if (!this.after) {
                    throw new GitException(NbBundle.getMessage(RenameCommand.class, (String)"MSG_Exception_TargetExists", (Object)this.target.getAbsolutePath()));
                }
            } else if (this.after) {
                throw new GitException(NbBundle.getMessage(RenameCommand.class, (String)"MSG_Exception_TargetDoesNotExist", (Object)this.target.getAbsolutePath()));
            }
        }
        return retval;
    }

    @Override
    protected String getCommandDescription() {
        return "git mv " + this.source + " " + this.target;
    }
}

