/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

class PDFOpenSupport
implements OpenCookie {
    private static final Logger LOG = Logger.getLogger(PDFOpenSupport.class.getName());
    private File f;
    private DataObject dObj;

    public PDFOpenSupport(File f) {
        this.f = f;
        try {
            this.dObj = DataObject.find((FileObject)FileUtil.toFileObject((File)f));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    public PDFOpenSupport(DataObject dObj) {
        this.dObj = dObj;
        this.f = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
    }

    public void open() {
        if (this.dObj != null) {
            this.f = FileUtil.toFile((FileObject)this.dObj.getPrimaryFile());
        }
        try {
            Desktop.getDesktop().open(this.f);
        }
        catch (IOException ex) {
            String msg = NbBundle.getMessage(PDFOpenSupport.class, (String)"EXC_could_not_open");
            LOG.log(Level.SEVERE, msg, ex);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }
}

