/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.SearchScopeNodeSelection;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class ActionManager<A extends SystemAction, S extends CallbackSystemAction, L extends Action>
implements PropertyChangeListener,
Runnable {
    protected static final Logger LOG = Logger.getLogger(ActionManager.class.getName());
    protected final A action;
    private final Set<TopComponent> activatedOnWindows = new WeakSet(8);
    private Object actionMapKey;
    private Class<SearchScopeNodeSelection.LookupSensitive> ssnslsClass;
    protected Class<L> lookUpSensitiveClass;
    private Class<S> origSysActionCls;

    protected ActionManager(Class<A> actionCls, Class<S> origSysActionCls) {
        this.origSysActionCls = origSysActionCls;
        this.action = (SystemAction)SharedClassObject.findObject(actionCls, (boolean)true);
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
        this.ssnslsClass = SearchScopeNodeSelection.LookupSensitive.class;
        this.initLookupSensitiveActionClass();
    }

    void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                ActionManager.this.cleanupWindowRegistry();
                return null;
            }
        });
        this.ssnslsClass = null;
        this.lookUpSensitiveClass = null;
    }

    @Override
    public void run() {
        this.someoneActivated();
    }

    private void cleanupWindowRegistry() {
        Object actionKey = this.getActionMapKey();
        for (TopComponent tc : this.activatedOnWindows) {
            Object origActionObj;
            Action origAction = null;
            Action currAction = null;
            Object origActionRef = tc.getClientProperty((Object)this.getMappedActionKey());
            if (origActionRef instanceof Reference && (origActionObj = ((Reference)origActionRef).get()) instanceof Action) {
                origAction = (Action)origActionObj;
            }
            if (origAction != null) {
                currAction = tc.getActionMap().get(actionKey);
            }
            if (currAction != null && currAction == origAction) {
                tc.getActionMap().put(actionKey, null);
            } else {
                ErrorManager.getDefault().log(16, "ActionMap mapping of Action changed for window " + tc.getName());
            }
            if (origActionRef == null) continue;
            tc.putClientProperty((Object)this.getMappedActionKey(), null);
        }
        this.activatedOnWindows.clear();
    }

    private void someoneActivated() {
        TopComponent win = TopComponent.getRegistry().getActivated();
        if (LOG.isLoggable(Level.FINER)) {
            String winId;
            if (win == null) {
                winId = "<null>";
            } else {
                String winName = win.getDisplayName();
                if (winName == null) {
                    winName = win.getHtmlDisplayName();
                }
                if (winName == null) {
                    winName = win.getName();
                }
                winName = winName != null ? '\"' + winName + '\"' : "<noname>";
                winId = winName + '(' + win.getClass().getName() + ')';
            }
            LOG.log(Level.FINER, "someoneActivated ({0})", winId);
        }
        if (win == null || win instanceof CloneableEditorSupport.Pane) {
            return;
        }
        Object key = this.getActionMapKey();
        ActionMap actionMap = win.getActionMap();
        if (actionMap.get(key) == null && this.activatedOnWindows.add(win)) {
            Action ls = this.createContextAwareInstance(win.getLookup());
            actionMap.put(key, ls);
            win.putClientProperty((Object)this.getMappedActionKey(), new WeakReference<Action>(ls));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("activated".equals(propName)) {
            this.someoneActivated();
        }
    }

    private Object getActionMapKey() {
        if (this.actionMapKey == null) {
            CallbackSystemAction systemAction = (CallbackSystemAction)SharedClassObject.findObject(this.origSysActionCls, (boolean)true);
            assert (systemAction != null);
            this.actionMapKey = systemAction.getActionMapKey();
        }
        return this.actionMapKey;
    }

    public abstract String getMappedActionKey();

    protected abstract Action createContextAwareInstance(Lookup var1);

    protected abstract void initLookupSensitiveActionClass();
}

