/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.CharConversionException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.awt.HtmlRenderer;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

final class NodeRenderer
extends JComponent
implements TreeCellRenderer {
    private static Rectangle checkBounds;
    private final HtmlRenderer.Renderer nodeRenderer;
    private final Image rootIconImage;
    private final JCheckBox checkBox;
    private Image deletedObjectIconImage;
    private String deletedObjectHtmlSuffix;
    private Component stringDisplayer = new JLabel(" ");
    private String filePathColorName;
    private String matchesCountRGB = null;

    NodeRenderer(boolean withCheckBox) {
        this.nodeRenderer = HtmlRenderer.createRenderer();
        this.rootIconImage = ImageUtilities.loadImage((String)"org/netbeans/modules/search/res/find.gif", (boolean)true);
        this.setLayout(null);
        if (!withCheckBox) {
            this.checkBox = null;
        } else {
            this.checkBox = new JCheckBox();
            this.checkBox.setBorderPaintedFlat(true);
            Color c = UIManager.getColor("Tree.textBackground");
            if (c == null) {
                c = Color.WHITE;
            }
            this.checkBox.setBackground(c);
            Dimension dim = this.checkBox.getPreferredSize();
            this.checkBox.setPreferredSize(new Dimension(dim.width, dim.height - 5));
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean checked;
        Image iconImage;
        boolean isHtml;
        String text;
        boolean isRoot;
        boolean bl = isRoot = row == 0;
        if (isRoot && value instanceof ResultTreeModel) {
            ResultTreeModel resultTreeModel = (ResultTreeModel)value;
            text = resultTreeModel.getRootDisplayName();
            isHtml = false;
            iconImage = this.rootIconImage;
            checked = this.checkBox != null ? resultTreeModel.isSelected() : false;
        } else if (value.getClass() == MatchingObject.class) {
            MatchingObject matchingObj = (MatchingObject)value;
            boolean valid = matchingObj.isObjectValid();
            if (valid) {
                Node node = matchingObj.getNodeDelegate();
                String folderPath = matchingObj.getRelativeSearchPath();
                int matchesCount = matchingObj.getMatchesCount();
                try {
                    text = matchingObj.getHtmlDisplayName();
                    isHtml = true;
                    if (text == null) {
                        text = XMLUtil.toElementContent((String)node.getDisplayName());
                    }
                    if (matchesCount > 0) {
                        text = text + this.getMatchesCountString(matchesCount);
                    }
                    text = text + " <font color='!" + this.getFilePathColor() + "'>" + XMLUtil.toElementContent((String)folderPath);
                }
                catch (CharConversionException ex) {
                    text = node.getDisplayName() + ' ' + '(' + folderPath + ')';
                    isHtml = false;
                }
                iconImage = node.getIcon(1);
            } else {
                text = matchingObj.getName() + this.getDeletedObjectHtmlSuffix();
                isHtml = true;
                iconImage = this.getDeletedObjectIconImage();
            }
            checked = this.checkBox != null ? matchingObj.isSelected() : false;
        } else {
            assert (value instanceof Node);
            Node node = (Node)value;
            text = node.getHtmlDisplayName();
            boolean bl2 = isHtml = text != null;
            if (!isHtml) {
                text = node.getDisplayName();
            }
            iconImage = node.getIcon(1);
            if (this.checkBox == null) {
                checked = false;
            } else {
                TreePath path = tree.getPathForRow(row);
                if (path == null) {
                    checked = true;
                } else {
                    MatchingObject matchingObj = (MatchingObject)path.getPathComponent(1);
                    if (matchingObj.isUniformSelection()) {
                        checked = matchingObj.isSelected();
                    } else {
                        int parentPathRow = tree.getRowForPath(path.getParentPath());
                        int index = row - parentPathRow - 1;
                        checked = matchingObj.isSubnodeSelected(index);
                    }
                }
            }
        }
        this.stringDisplayer = this.nodeRenderer.getTreeCellRendererComponent(tree, (Object)text, selected, expanded, leaf, row, hasFocus);
        this.nodeRenderer.setHtml(isHtml);
        this.nodeRenderer.setIcon((Icon)new ImageIcon(iconImage));
        if (this.stringDisplayer.getBackground() == null) {
            this.stringDisplayer.setBackground(tree.getBackground());
        }
        if (this.stringDisplayer.getForeground() == null) {
            this.stringDisplayer.setForeground(tree.getForeground());
        }
        if (this.checkBox != null) {
            this.checkBox.setSelected(checked);
            return this;
        }
        return this.stringDisplayer;
    }

    private String getFilePathColor() {
        if (this.filePathColorName == null) {
            UIDefaults uiDefaults = UIManager.getDefaults();
            this.filePathColorName = uiDefaults.getColor("Tree.selectionBackground").equals(uiDefaults.getColor("controlDkShadow")) ? "Tree.selectionBorderColor" : "controlDkShadow";
        }
        return this.filePathColorName;
    }

    private String getMatchesCountString(int matchesCount) throws CharConversionException {
        if (this.matchesCountRGB == null) {
            Color color = UIManager.getDefaults().getColor("controlDkShadow");
            if (color == null || Color.WHITE.equals(color)) {
                color = Color.DARK_GRAY;
            }
            color = color.darker();
            String rgb = Integer.toHexString(color.getRGB());
            this.matchesCountRGB = rgb.substring(2, rgb.length()).toUpperCase();
        }
        String msg = NbBundle.getMessage(NodeRenderer.class, (String)"TEXT_NUM_MATCHES_IN_NODE", (Object)matchesCount);
        String xmlMsg = XMLUtil.toElementContent((String)msg);
        return "<font color='#" + this.matchesCountRGB + "'> " + xmlMsg + " </font>";
    }

    @Override
    public void paint(Graphics g) {
        Dimension checkDim = this.checkBox.getSize();
        Dimension labelDim = this.stringDisplayer.getPreferredSize();
        int labelY = checkDim.height >= labelDim.height ? (checkDim.height - labelDim.height) / 2 : 0;
        this.checkBox.paint(g);
        assert (this.stringDisplayer.getBounds().x == 0 && this.stringDisplayer.getBounds().y == 0);
        g.translate(checkDim.width, labelY);
        this.stringDisplayer.paint(g);
        g.translate(-checkDim.width, -labelY);
    }

    @Override
    public Dimension getPreferredSize() {
        this.stringDisplayer.setFont(this.getFont());
        Dimension prefSize = new Dimension(this.stringDisplayer.getPreferredSize());
        Dimension checkDim = this.checkBox.getPreferredSize();
        prefSize.width += checkDim.width;
        prefSize.height = Math.max(prefSize.height, checkDim.height);
        return prefSize;
    }

    @Override
    public void doLayout() {
        Dimension checkDim = this.checkBox.getPreferredSize();
        Dimension labelDim = this.stringDisplayer.getPreferredSize();
        int checkWidth = checkDim.width;
        int checkHeight = checkDim.height;
        int labelWidth = labelDim.width;
        int labelHeight = labelDim.height;
        int heightDif = labelHeight - checkHeight;
        int checkY = heightDif > 2 ? heightDif / 2 - 1 : 0;
        int labelY = heightDif < 0 ? -heightDif / 2 : 0;
        this.checkBox.setBounds(0, checkY, checkWidth, checkHeight);
        this.stringDisplayer.setBounds(checkWidth, labelY, labelWidth, labelHeight);
        if (checkBounds == null) {
            checkBounds = this.checkBox.getBounds();
        }
    }

    private Image getDeletedObjectIconImage() {
        if (this.deletedObjectIconImage == null) {
            this.deletedObjectIconImage = ImageUtilities.loadImage((String)"org/netbeans/modules/search/res/invalid.png", (boolean)true);
        }
        return this.deletedObjectIconImage;
    }

    private String getDeletedObjectHtmlSuffix() {
        if (this.deletedObjectHtmlSuffix == null) {
            this.deletedObjectHtmlSuffix = "&nbsp;&nbsp;<font color=\"#ff0000\">" + NbBundle.getMessage(this.getClass(), (String)"LBL_InvalidFile") + "</font>";
        }
        return this.deletedObjectHtmlSuffix;
    }

    static Rectangle getCheckBoxRectangle() {
        return (Rectangle)checkBounds.clone();
    }
}

