/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

final class SpecialSearchGroup
extends DataObjectSearchGroup {
    final BasicSearchCriteria basicCriteria;
    final boolean hasExtraSearchTypes;
    private final SearchScope searchScope;
    private SearchTask listeningSearchTask;
    private CommonSearchRoot commonSearchRoot = new CommonSearchRoot();
    private LinkedList searchItems;

    SpecialSearchGroup(BasicSearchCriteria basicCriteria, Collection<SearchType> extraSearchTypes, SearchScope searchScope) {
        this.basicCriteria = basicCriteria;
        this.hasExtraSearchTypes = !extraSearchTypes.isEmpty();
        this.searchScope = searchScope;
        if (basicCriteria == null && !this.hasExtraSearchTypes) {
            assert (false);
            throw new IllegalArgumentException();
        }
        if (this.hasExtraSearchTypes) {
            for (SearchType searchType : extraSearchTypes) {
                this.add(searchType);
            }
        }
    }

    protected void prepareSearch() {
        this.searchItems = new LinkedList();
        SearchInfo sInfo = this.searchScope.getSearchInfo();
        if (sInfo instanceof SearchInfo.Files) {
            this.addSearchItems(((SearchInfo.Files)sInfo).filesToSearch());
        } else {
            this.addSearchItems(sInfo.objectsToSearch());
        }
    }

    private void addSearchItems(Iterator items) {
        Iterator j = items;
        while (j.hasNext()) {
            if (this.stopped) {
                return;
            }
            Object file = j.next();
            this.searchItems.add(file);
            if (file instanceof FileObject) {
                this.commonSearchRoot.update((FileObject)file);
                continue;
            }
            if (!(file instanceof DataObject)) continue;
            this.commonSearchRoot.update(((DataObject)file).getPrimaryFile());
        }
    }

    public void doSearch() {
        this.notifyStarted(this.searchItems.size());
        int index = 0;
        while (!this.searchItems.isEmpty()) {
            if (this.stopped) {
                return;
            }
            this.processSearchObject(this.searchItems.poll());
            this.notifyProgress(index++);
        }
    }

    protected void processSearchObject(Object searchObject) {
        if (!this.hasExtraSearchTypes) {
            FileObject fileObj;
            assert (this.basicCriteria != null);
            if (searchObject instanceof DataObject) {
                DataObject dataObj = (DataObject)searchObject;
                if (this.basicCriteria.matches(dataObj)) {
                    this.notifyMatchingObjectFound(dataObj);
                }
            } else if (searchObject instanceof FileObject && this.basicCriteria.matches(fileObj = (FileObject)searchObject)) {
                this.notifyMatchingObjectFound(fileObj);
            }
            return;
        }
        if (this.basicCriteria == null || this.basicCriteria.matches((DataObject)searchObject)) {
            super.processSearchObject(searchObject);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.notifyMatchingObjectFound((DataObject)newValue);
    }

    private void notifyMatchingObjectFound(Object obj) {
        if (this.listeningSearchTask != null) {
            Charset charset = this.basicCriteria != null ? this.basicCriteria.getLastUsedCharset() : null;
            this.listeningSearchTask.matchingObjectFound(obj, charset);
        }
    }

    private void notifyStarted(int unitsCount) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.searchStarted(unitsCount);
        }
    }

    private void notifyProgress(int progress) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.progress(progress);
        }
    }

    void setListeningSearchTask(SearchTask searchTask) {
        this.listeningSearchTask = searchTask;
    }

    SearchScope getSearchScope() {
        return this.searchScope;
    }

    protected void onStopSearch() {
        try {
            this.basicCriteria.terminateCurrentSearches();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    synchronized FileObject getCommonSearchFolder() {
        return this.commonSearchRoot.getFileObject();
    }

    static class CommonSearchRoot {
        private int minRelPathLen = 4;
        private boolean exists = true;
        private List<FileObject> path;
        private FileObject file = null;

        public CommonSearchRoot() {
        }

        public CommonSearchRoot(int minRelPathLen) {
            if (minRelPathLen < 1) {
                throw new IllegalArgumentException();
            }
            this.minRelPathLen = minRelPathLen;
        }

        synchronized void update(FileObject fo) {
            if (this.exists) {
                if (this.exists && this.file == null) {
                    this.initCommonPath(fo);
                } else if (!FileUtil.isParentOf((FileObject)this.file, (FileObject)fo)) {
                    List<FileObject> p = CommonSearchRoot.filePathAsList(fo.getParent());
                    this.path = CommonSearchRoot.findCommonPath(this.path, p);
                    if (this.path.isEmpty()) {
                        this.path = null;
                        this.file = null;
                        this.exists = false;
                    } else {
                        this.file = this.path.get(this.path.size() - 1);
                    }
                }
            }
        }

        static List<FileObject> findCommonPath(List<FileObject> p1, List<FileObject> p2) {
            Iterator<FileObject> i1 = p1.iterator();
            Iterator<FileObject> i2 = p2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                FileObject fo2;
                FileObject fo1 = i1.next();
                if (fo1.equals(fo2 = i2.next())) continue;
                return p1.subList(0, p1.indexOf(fo1));
            }
            return p1;
        }

        static List<FileObject> filePathAsList(FileObject fo) {
            LinkedList<FileObject> path = new LinkedList<FileObject>();
            for (FileObject p = fo; p != null; p = p.getParent()) {
                path.add(0, p);
            }
            return path;
        }

        private void initCommonPath(FileObject fo) {
            Object p;
            for (p = fo.getParent(); p != null; p = p.getParent()) {
                FileObject projectParent;
                if (!this.isLikeProjectFolder((FileObject)p) || (projectParent = p.getParent()) == null) continue;
                this.file = projectParent;
                this.path = CommonSearchRoot.filePathAsList(projectParent);
                return;
            }
            p = CommonSearchRoot.filePathAsList(fo);
            if (p.size() > this.minRelPathLen) {
                this.path = p.subList(0, p.size() - this.minRelPathLen);
                this.file = this.path.get(this.path.size() - 1);
            } else {
                this.exists = false;
            }
        }

        private boolean isLikeProjectFolder(FileObject folder) {
            if (folder.getFileObject("src") != null) {
                return true;
            }
            return folder.getFileObject("nbproject") != null;
        }

        synchronized FileObject getFileObject() {
            if (this.exists) {
                return this.file;
            }
            return null;
        }
    }
}

