/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.CategoryContainer;
import org.netbeans.modules.profiler.categorization.api.CustomMarker;
import org.netbeans.modules.profiler.categorization.api.definitions.CustomCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.PackageCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.SingleTypeCategoryDefinition;
import org.netbeans.modules.profiler.categorization.api.definitions.SubtypeCategoryDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CategoryBuilder {
    private static final Logger LOGGER = Logger.getLogger(CategoryBuilder.class.getName());
    private static final String CATEGORY_ATTRIB_CUSTOM = "custom";
    private static final String CATEGORY_ATTRIB_EXCLUDES = "excludes";
    private static final String CATEGORY_ATTRIB_INCLUDES = "includes";
    private static final String CATEGORY_ATTRIB_INSTANCENAME = "instanceClass";
    private static final String CATEGORY_ATTRIB_PREFIX = ".";
    private static final String CATEGORY_ATTRIB_SUBTYPES = "subtypes";
    private static final String CATEGORY_ATTRIB_TYPE = "type";
    private static final String CATEGORY_ATTRIB_PACKAGE = "package";
    private static final String SHADOW_SUFFIX = "shadow";
    private String projectType;
    private CategoryContainer rootCategory = null;
    private Lookup.Provider project;

    public CategoryBuilder(Lookup.Provider proj, String projectTypeId) {
        this.project = proj;
        this.projectType = projectTypeId;
    }

    public final synchronized Category getRootCategory() {
        if (this.rootCategory == null) {
            this.rootCategory = new CategoryContainer("ROOT", NbBundle.getMessage(CategoryBuilder.class, (String)"ROOT_CATEGORY_NAME"), Mark.DEFAULT);
            FileObject aoi = FileUtil.getConfigFile((String)("Projects/" + this.projectType + "/NBProfiler/Categories"));
            if (aoi != null) {
                Enumeration folders = aoi.getChildren(false);
                while (folders.hasMoreElements()) {
                    FileObject folder = (FileObject)folders.nextElement();
                    this.processCategories(this.rootCategory, folder);
                }
            }
        }
        return this.rootCategory;
    }

    protected final Lookup.Provider getProject() {
        return this.project;
    }

    private void processCategories(CategoryContainer container, FileObject node) {
        if (SHADOW_SUFFIX.equals(node.getExt())) {
            String reference = (String)node.getAttribute("originalFile");
            try {
                FileObject refNode = node.getFileSystem().findResource(reference);
                if (refNode != null) {
                    this.processCategories(container, refNode);
                }
            }
            catch (FileStateInvalidException e) {
                LOGGER.log(Level.SEVERE, "Can not process {0}", node.getPath());
                LOGGER.throwing(CategoryBuilder.class.getName(), "processCategories", e);
            }
        } else if (node.isFolder()) {
            String label = (String)node.getAttribute("displayName");
            label = label != null ? label : node.getName();
            CategoryContainer newCategory = new CategoryContainer(node.getPath(), label);
            container.add(newCategory);
            Enumeration subNodes = node.getFolders(false);
            while (subNodes.hasMoreElements()) {
                FileObject subNode = (FileObject)subNodes.nextElement();
                String nodeName = subNode.getName();
                if (nodeName.startsWith(CATEGORY_ATTRIB_PREFIX)) {
                    int i;
                    String[] excludesArr;
                    String[] includesArr;
                    String includes;
                    String excludes;
                    FileObject typeDef;
                    Enumeration definitions;
                    if (nodeName.endsWith(CATEGORY_ATTRIB_SUBTYPES) && nodeName.length() == CATEGORY_ATTRIB_SUBTYPES.length() + 1) {
                        definitions = subNode.getChildren(false);
                        while (definitions.hasMoreElements()) {
                            typeDef = (FileObject)definitions.nextElement();
                            excludes = (String)typeDef.getAttribute(CATEGORY_ATTRIB_EXCLUDES);
                            includes = (String)typeDef.getAttribute(CATEGORY_ATTRIB_INCLUDES);
                            includesArr = includes != null ? includes.split(",") : null;
                            String[] stringArray = excludesArr = excludes != null ? excludes.split(",") : null;
                            if (includesArr != null) {
                                for (i = 0; i < includesArr.length; ++i) {
                                    includesArr[i] = includesArr[i].trim();
                                }
                            }
                            if (excludesArr != null) {
                                for (i = 0; i < excludesArr.length; ++i) {
                                    excludesArr[i] = excludesArr[i].trim();
                                }
                            }
                            newCategory.getDefinitions().add(new SubtypeCategoryDefinition(newCategory, typeDef.getNameExt(), includesArr, excludesArr));
                        }
                        continue;
                    }
                    if (nodeName.endsWith(CATEGORY_ATTRIB_TYPE) && nodeName.length() == CATEGORY_ATTRIB_TYPE.length() + 1) {
                        definitions = subNode.getChildren(false);
                        while (definitions.hasMoreElements()) {
                            typeDef = (FileObject)definitions.nextElement();
                            excludes = (String)typeDef.getAttribute(CATEGORY_ATTRIB_EXCLUDES);
                            includes = (String)typeDef.getAttribute(CATEGORY_ATTRIB_INCLUDES);
                            includesArr = includes != null ? includes.split(",") : null;
                            String[] stringArray = excludesArr = excludes != null ? excludes.split(",") : null;
                            if (includesArr != null) {
                                for (i = 0; i < includesArr.length; ++i) {
                                    includesArr[i] = includesArr[i].trim();
                                }
                            }
                            if (excludesArr != null) {
                                for (i = 0; i < excludesArr.length; ++i) {
                                    excludesArr[i] = excludesArr[i].trim();
                                }
                            }
                            newCategory.getDefinitions().add(new SingleTypeCategoryDefinition(newCategory, typeDef.getNameExt(), includesArr, excludesArr));
                        }
                        continue;
                    }
                    if (nodeName.endsWith(CATEGORY_ATTRIB_CUSTOM) && nodeName.length() == CATEGORY_ATTRIB_CUSTOM.length() + 1) {
                        String instanceClass = (String)subNode.getAttribute(CATEGORY_ATTRIB_INSTANCENAME);
                        if (instanceClass == null) continue;
                        Exception thrownException = null;
                        try {
                            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                            Class<?> markerClz = cl.loadClass(instanceClass);
                            CustomMarker marker = (CustomMarker)markerClz.getConstructor(Lookup.Provider.class, Mark.class).newInstance(this.project, newCategory.getAssignedMark());
                            if (marker != null) {
                                newCategory.getDefinitions().add(new CustomCategoryDefinition(newCategory, marker));
                            }
                        }
                        catch (InstantiationException ex) {
                            thrownException = ex;
                        }
                        catch (IllegalAccessException ex) {
                            thrownException = ex;
                        }
                        catch (IllegalArgumentException ex) {
                            thrownException = ex;
                        }
                        catch (InvocationTargetException ex) {
                            thrownException = ex;
                        }
                        catch (NoSuchMethodException ex) {
                            thrownException = ex;
                        }
                        catch (SecurityException ex) {
                            thrownException = ex;
                        }
                        catch (ClassNotFoundException ex) {
                            thrownException = ex;
                        }
                        if (thrownException == null) continue;
                        LOGGER.logp(Level.WARNING, CategoryBuilder.class.getName(), "processCategories", "Error while building profiling results categories", thrownException);
                        continue;
                    }
                    if (nodeName.endsWith(CATEGORY_ATTRIB_PACKAGE) && nodeName.length() == CATEGORY_ATTRIB_PACKAGE.length() + 1) {
                        definitions = subNode.getChildren(false);
                        while (definitions.hasMoreElements()) {
                            FileObject packageDef = (FileObject)definitions.nextElement();
                            Boolean recursive = (Boolean)packageDef.getAttribute("recursive");
                            newCategory.getDefinitions().add(new PackageCategoryDefinition(newCategory, packageDef.getNameExt(), recursive != null ? recursive : true));
                        }
                        continue;
                    }
                    LOGGER.logp(Level.SEVERE, CategoryBuilder.class.getName(), "processCategories", "Unkown category attribute name :" + nodeName);
                    continue;
                }
                this.processCategories(newCategory, subNode);
            }
        }
    }
}

