/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp.ui;

import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;

public class HyperlinkLabel
extends HTMLLabel {
    private Runnable actionPerformer;
    private String focusedText;
    private String normalText;

    public HyperlinkLabel(String normalText, String focusedText, Runnable actionPerformer) {
        this.setFocusable(true);
        this.setHighlighter(null);
        this.setText(normalText, focusedText);
        this.actionPerformer = actionPerformer;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HyperlinkLabel.this.setText(HyperlinkLabel.this.focusedText);
            }

            @Override
            public void focusLost(FocusEvent e) {
                HyperlinkLabel.this.setText(HyperlinkLabel.this.normalText);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    HyperlinkLabel.this.actionPerformer.run();
                }
            }
        });
    }

    public void setText(String normalText, String focusedText) {
        this.normalText = normalText;
        this.focusedText = focusedText;
        this.setText(this.isFocusOwner() ? focusedText : normalText);
    }

    public void setText(String value) {
        Font font = this.getFont();
        value = value.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        value = value.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        super.setText("<html><body style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + value + "</body></html>");
    }

    protected void showURL(URL url) {
        this.actionPerformer.run();
    }
}

