/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.stp.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.stp.ui.GlobalFiltersPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class QuickFilterPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String FILTER_TYPE_LABEL_TEXT = NbBundle.getMessage(QuickFilterPanel.class, (String)"QuickFilterPanel_FilterTypeLabelText");
    private static final String FILTER_TYPE_EXCLUSIVE_RADIO_TEXT = NbBundle.getMessage(QuickFilterPanel.class, (String)"QuickFilterPanel_FilterTypeExclusiveRadioText");
    private static final String FILTER_TYPE_INCLUSIVE_RADIO_TEXT = NbBundle.getMessage(QuickFilterPanel.class, (String)"QuickFilterPanel_FilterTypeInclusiveRadioText");
    private static final String FILTER_VALUE_LABEL_TEXT = NbBundle.getMessage(QuickFilterPanel.class, (String)"QuickFilterPanel_FilterValueLabelText");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_OkButtonText");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_CancelButtonText");
    private static final String EMPTY_FILTER_MSG = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_EmptyFilterMsg");
    private static final String INVALID_FILTER_MSG = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_InvalidFilterMsg");
    private static final String HINT_MSG = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_HintMsg");
    private static final String FILTER_TYPE_EXCLUSIVE_RADIO_ACCESS_DESCR = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_FilterTypeExclusiveRadioAccessDescr");
    private static final String FILTER_TYPE_INCLUSIVE_RADIO_ACCESS_DESCR = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_FilterTypeInclusiveRadioAccessDescr");
    private static final String FILTER_VALUE_TEXT_FIELD_ACCESS_NAME = NbBundle.getMessage(GlobalFiltersPanel.class, (String)"QuickFilterPanel_FilterValueTextFieldAccessName");
    private static final String HELP_CTX_KEY = "QuickFilterPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("QuickFilterPanel.HelpCtx");
    private static QuickFilterPanel defaultInstance;
    private ButtonGroup filterTypeButtonGroup;
    private HTMLTextArea hintArea;
    private JButton CancelButton;
    private JButton OKButton;
    private JLabel filterTypeLabel;
    private JLabel filterValueHintLabel;
    private JLabel filterValueLabel;
    private JRadioButton filterTypeExclusiveRadio;
    private JRadioButton filterTypeInclusiveRadio;
    private JTextArea filterValueTextArea;
    private SimpleFilter quickFilter;

    private QuickFilterPanel() {
        this.initComponents();
    }

    public static QuickFilterPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new QuickFilterPanel();
        }
        return defaultInstance;
    }

    public JButton getCancelButton() {
        return this.CancelButton;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public JButton getOKButton() {
        return this.OKButton;
    }

    public void applyChanges() {
        if (this.filterTypeExclusiveRadio.isSelected()) {
            this.quickFilter.setFilterType(1);
        } else {
            this.quickFilter.setFilterType(2);
        }
        this.quickFilter.setFilterValue(this.getFilterValueInternal());
    }

    public void init() {
        this.init(FilterUtils.QUICK_FILTER);
    }

    public void init(SimpleFilter quickFilter) {
        this.quickFilter = quickFilter;
        if (this.filterTypeExclusiveRadio != null && this.filterTypeInclusiveRadio != null) {
            if (quickFilter.getFilterType() == 1) {
                this.filterTypeExclusiveRadio.setSelected(true);
            } else {
                this.filterTypeInclusiveRadio.setSelected(true);
            }
        }
        if (this.filterTypeLabel != null) {
            String[] filterParts = FilterUtils.getSeparateFilters((String)quickFilter.getFilterValue());
            ArrayList<String> filterPartsList = new ArrayList<String>(filterParts.length);
            for (String filterPart : filterParts) {
                filterPartsList.add(filterPart);
            }
            Collections.sort(filterPartsList);
            StringBuffer val = new StringBuffer(filterParts.length);
            Iterator it = filterPartsList.iterator();
            while (it.hasNext()) {
                val.append((String)it.next());
                if (!it.hasNext()) continue;
                val.append("\n");
            }
            this.filterValueTextArea.setText(val.toString());
            this.filterValueTextArea.setCaretPosition(0);
            this.filterValueTextArea.requestFocus();
        }
        this.checkFilterValue();
    }

    private boolean isFilterValid() {
        String[] filterParts = this.getFilterValues();
        for (int i = 0; i < filterParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)filterParts[i])) continue;
            return false;
        }
        return true;
    }

    private String getFilterValueInternal() {
        StringBuffer convertedValue = new StringBuffer();
        String[] filterValues = this.getFilterValues();
        for (int i = 0; i < filterValues.length; ++i) {
            String filterValue = filterValues[i].trim();
            if (i != filterValues.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ", ";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private String[] getFilterValues() {
        return this.filterValueTextArea.getText().split("\\n");
    }

    private void checkFilterValue() {
        if (this.filterValueTextArea == null) {
            return;
        }
        this.getFilterValues();
        String filterValue = this.filterValueTextArea.getText().trim();
        if (filterValue.length() == 0) {
            this.filterValueHintLabel.setText(EMPTY_FILTER_MSG);
            this.OKButton.setEnabled(false);
            this.filterValueTextArea.setForeground(Color.red);
            this.filterValueTextArea.setSelectedTextColor(Color.red);
        } else if (!this.isFilterValid()) {
            this.filterValueHintLabel.setText(INVALID_FILTER_MSG);
            this.OKButton.setEnabled(false);
            this.filterValueTextArea.setForeground(Color.red);
            this.filterValueTextArea.setSelectedTextColor(Color.red);
        } else {
            this.filterValueHintLabel.setText(" ");
            this.OKButton.setEnabled(true);
            this.filterValueTextArea.setForeground(UIManager.getColor("Label.foreground"));
            this.filterValueTextArea.setSelectedTextColor(UIManager.getColor("Label.foreground"));
        }
    }

    private void initComponents() {
        this.OKButton = new JButton(OK_BUTTON_TEXT);
        this.CancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.filterTypeLabel = new JLabel();
        this.filterValueLabel = new JLabel();
        this.filterValueHintLabel = new JLabel();
        this.filterTypeButtonGroup = new ButtonGroup();
        this.filterTypeExclusiveRadio = new JRadioButton();
        this.filterTypeInclusiveRadio = new JRadioButton();
        this.filterValueTextArea = new JTextArea();
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.setLayout(new GridBagLayout());
        this.filterTypeLabel.setText(FILTER_TYPE_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 15);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.filterTypeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.filterTypeExclusiveRadio, (String)FILTER_TYPE_EXCLUSIVE_RADIO_TEXT);
        this.filterTypeExclusiveRadio.getAccessibleContext().setAccessibleDescription(FILTER_TYPE_EXCLUSIVE_RADIO_ACCESS_DESCR);
        this.filterTypeButtonGroup.add(this.filterTypeExclusiveRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.filterTypeInclusiveRadio, (String)FILTER_TYPE_INCLUSIVE_RADIO_TEXT);
        this.filterTypeInclusiveRadio.getAccessibleContext().setAccessibleDescription(FILTER_TYPE_INCLUSIVE_RADIO_ACCESS_DESCR);
        this.filterTypeInclusiveRadio.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.filterTypeButtonGroup.add(this.filterTypeInclusiveRadio);
        JPanel filterRadiosPanel = new JPanel(new FlowLayout(3, 0, 0));
        filterRadiosPanel.add(this.filterTypeExclusiveRadio);
        filterRadiosPanel.add(this.filterTypeInclusiveRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 0, 5, 15);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)filterRadiosPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.filterValueLabel, (String)FILTER_VALUE_LABEL_TEXT);
        this.filterValueLabel.setLabelFor(this.filterValueTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.filterValueLabel, gridBagConstraints);
        this.filterValueTextArea.getAccessibleContext().setAccessibleName(FILTER_VALUE_TEXT_FIELD_ACCESS_NAME);
        this.filterValueTextArea.setSelectionColor(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.filterValueTextArea.setSelectedTextColor(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.filterValueTextArea.getDocument().addDocumentListener(new FilterValueTextFieldDocumentListener());
        JTextArea temp = new JTextArea();
        temp.setColumns(45);
        temp.setRows(6);
        JScrollPane filterValueScrollPane = new JScrollPane(this.filterValueTextArea, 20, 30);
        filterValueScrollPane.setPreferredSize(new Dimension(temp.getPreferredSize().width, temp.getPreferredSize().height));
        temp = null;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)filterValueScrollPane, gridBagConstraints);
        this.filterValueHintLabel.setText(" ");
        this.filterValueHintLabel.setForeground(new Color(89, 79, 191));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(7, 5, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.filterValueHintLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JPanel(), gridBagConstraints);
        Color panelBackground = UIManager.getColor("Panel.background");
        Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
        this.hintArea.setText(HINT_MSG);
        this.hintArea.setEnabled(false);
        this.hintArea.setDisabledTextColor(Color.darkGray);
        this.hintArea.setBackground(hintBackground);
        this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 7, 0, 7);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.hintArea, gridBagConstraints);
        this.checkFilterValue();
    }

    private final class FilterValueTextFieldDocumentListener
    implements DocumentListener {
        private FilterValueTextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            QuickFilterPanel.this.checkFilterValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            QuickFilterPanel.this.checkFilterValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            QuickFilterPanel.this.checkFilterValue();
        }
    }
}

