/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.debugger.jpda.ui.BreakpointOutput;
import org.netbeans.modules.web.debug.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JspLineBreakpoint
extends Breakpoint {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 2;
    private String printText;
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private LineBreakpoint javalb;

    public JspLineBreakpoint() {
    }

    public JspLineBreakpoint(String url, int lineNumber) {
        this.url = url;
        this.lineNumber = lineNumber;
        String pt = NbBundle.getMessage(JspLineBreakpoint.class, (String)"CTL_Default_Print_Text");
        this.printText = pt.replace("{jspName}", Utils.getJspName(url));
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        Utils.log("jsp url: " + url);
        String filter = Utils.getClassFilter(url);
        Utils.log("filter: " + filter);
        this.javalb = LineBreakpoint.create((String)url, (int)lineNumber);
        this.javalb.setStratum("JSP");
        this.javalb.setSourceName(Utils.getJspName(url));
        this.javalb.setSourcePath(Utils.getJspPath(url));
        this.javalb.setPreferredClassName(filter);
        this.javalb.setHidden(true);
        this.javalb.setPrintText(this.printText);
        String context = Utils.getContextPath(url);
        String condition = "request.getContextPath().equals(\"" + context + "\")";
        this.javalb.setCondition(condition);
        Utils.log("condition: " + condition);
        this.javalb.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("validity".equals(evt.getPropertyName())) {
                    JspLineBreakpoint.this.setValidity(JspLineBreakpoint.this.javalb.getValidity(), JspLineBreakpoint.this.javalb.getValidityMessage());
                    JspLineBreakpoint.this.breakpointOutput((Breakpoint.VALIDITY)evt.getNewValue());
                }
            }
        });
        this.javalb.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                List lamls = DebuggerManager.getDebuggerManager().getCurrentEngine().lookup(null, LazyActionsManagerListener.class);
                for (LazyActionsManagerListener lam : lamls) {
                    if (!(lam instanceof BreakpointOutput)) continue;
                    ((BreakpointOutput)lam).substituteAndPrintText(JspLineBreakpoint.this.getPrintText(), event);
                }
            }
        });
        d.addBreakpoint((Breakpoint)this.javalb);
        this.setURL(url);
        this.setLineNumber(lineNumber);
    }

    public static JspLineBreakpoint create(String url, int lineNumber) {
        return new JspLineBreakpoint(url, lineNumber);
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        if (this.javalb != null) {
            this.javalb.setSuspend(s);
        }
        this.firePropertyChange(PROP_SUSPEND, new Integer(old), new Integer(s));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (this.printText == printText) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        if (this.javalb != null) {
            this.javalb.setPrintText(printText);
        }
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    protected void dispose() {
        if (this.javalb != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.javalb);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.javalb != null) {
            this.javalb.disable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.javalb != null) {
            this.javalb.enable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.FALSE, Boolean.TRUE);
    }

    public void setURL(String url) {
        if (url == this.url || url != null && this.url != null && url.equals(this.url)) {
            return;
        }
        String old = this.url;
        this.url = url;
        this.firePropertyChange(PROP_URL, old, url);
    }

    public String getURL() {
        return this.url;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int ln) {
        if (ln == this.lineNumber) {
            return;
        }
        int old = this.lineNumber;
        this.lineNumber = ln;
        if (this.javalb != null) {
            this.javalb.setLineNumber(ln);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(this.getLineNumber()));
    }

    public void setCondition(String c) {
        if (c != null) {
            c = c.trim();
        }
        if (c == this.condition || c != null && this.condition != null && this.condition.equals(c)) {
            return;
        }
        String old = this.condition;
        this.condition = c;
        if (this.javalb != null) {
            this.javalb.setCondition(c);
        }
        this.firePropertyChange(PROP_CONDITION, old, this.condition);
    }

    public String getCondition() {
        return this.condition;
    }

    public String toString() {
        return "JspLineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    public LineBreakpoint getJavalb() {
        return this.javalb;
    }

    public void setJavalb(LineBreakpoint javalb) {
        this.javalb = javalb;
    }

    public void setGroupName(String newGroupName) {
        super.setGroupName(newGroupName);
        this.javalb.setGroupName(newGroupName);
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new JspLineGroupProperties();
    }

    private void breakpointOutput(Breakpoint.VALIDITY newValidity) {
        List lamls = DebuggerManager.getDebuggerManager().getCurrentEngine().lookup(null, LazyActionsManagerListener.class);
        for (LazyActionsManagerListener lam : lamls) {
            if (!(lam instanceof BreakpointOutput)) continue;
            ((BreakpointOutput)lam).printValidityMessage((Breakpoint)this, newValidity, this.getURL(), this.getLineNumber());
        }
    }

    private final class JspLineGroupProperties
    extends Breakpoint.GroupProperties {
        private JspLineGroupProperties() {
        }

        public String getLanguage() {
            return "JSP";
        }

        public String getType() {
            return NbBundle.getMessage(JspLineBreakpoint.class, (String)"LineBrkp_Type");
        }

        private FileObject getFile() {
            FileObject fo;
            try {
                fo = URLMapper.findFileObject((URL)new URL(JspLineBreakpoint.this.url));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                fo = null;
            }
            return fo;
        }

        public FileObject[] getFiles() {
            FileObject fo = this.getFile();
            if (fo != null) {
                return new FileObject[]{fo};
            }
            return null;
        }

        public Project[] getProjects() {
            FileObject f = this.getFile();
            while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
            }
            if (f != null) {
                try {
                    return new Project[]{ProjectManager.getDefault().findProject(f)};
                }
                catch (IOException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public DebuggerEngine[] getEngines() {
            DebuggerEngine[] engines = JspLineBreakpoint.this.javalb.getGroupProperties().getEngines();
            if (engines == null) {
                return null;
            }
            for (int i = 0; i < engines.length; ++i) {
                DebuggerEngine de = ((Session)engines[i].lookupFirst(null, Session.class)).getEngineForLanguage("JSP");
                if (de == null) continue;
                engines[i] = de;
            }
            return engines;
        }

        public boolean isHidden() {
            return JspLineBreakpoint.this.isHidden();
        }
    }
}

