/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PanelModuleDetectionVisual
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Vector<Vector<String>> modules = new Vector();
    private static final int REL_PATH_INDEX = 0;
    private static final int TYPE_INDEX = 1;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private File eaLocation;
    private JButton addModuleButton;
    private JLabel appModulesLabel;
    private JScrollPane moduleSP;
    private JTable moduleTable;
    private JButton removeModuleButton;

    public PanelModuleDetectionVisual() {
        this.initComponents();
        this.initModuleTable();
        this.setName(PanelModuleDetectionVisual.getMessage("LBL_IW_ApplicationModulesStep"));
        this.putClientProperty("NewProjectWizard_Title", PanelModuleDetectionVisual.getMessage("TXT_ImportProject"));
        this.getAccessibleContext().setAccessibleDescription(PanelModuleDetectionVisual.getMessage("ACS_NWP1_NamePanel_A11YDesc"));
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void initModuleTable() {
        Vector<String> colNames = new Vector<String>();
        colNames.add(PanelModuleDetectionVisual.getMessage("LBL_IW_Module"));
        colNames.add(PanelModuleDetectionVisual.getMessage("LBL_IW_Type"));
        DefaultTableModel moduleTableModel = new DefaultTableModel(this.modules, colNames);
        this.moduleTable.setModel(moduleTableModel);
        TableColumnModel tcm = this.moduleTable.getColumnModel();
        TableColumn tc = tcm.getColumn(1);
        ModuleTypeRenderer renderer = new ModuleTypeRenderer();
        tc.setCellRenderer(renderer);
        tc.setCellEditor(new ModuleTypeEditor());
        this.moduleTable.setRowHeight((int)renderer.getPreferredSize().getHeight());
        this.moduleSP.getViewport().setBackground(this.moduleTable.getBackground());
    }

    void read(WizardDescriptor settings) {
        File newEALocation = (File)settings.getProperty("sourceRoot");
        assert (newEALocation != null) : "Location is not available!";
        if (!newEALocation.equals(this.eaLocation)) {
            this.modules.removeAllElements();
        }
        this.eaLocation = newEALocation;
        FileObject eaLocationFO = FileUtil.toFileObject((File)this.eaLocation);
        Map<FileObject, ModuleType> modules = ModuleType.detectModules(eaLocationFO);
        for (FileObject moduleDir : modules.keySet()) {
            this.addModuleToTable(FileUtil.toFile((FileObject)moduleDir));
        }
        this.getModuleTableModel().fireTableDataChanged();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        for (Vector<String> module : this.modules) {
            String moduleDirectory = module.get(0);
            if (!this.isForbiddenProject(moduleDirectory)) continue;
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"MSG_ModuleNotJavaEEModule", (Object)moduleDirectory));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    private boolean isForbiddenProject(String moduleDirectory) {
        File module = FileUtil.normalizeFile((File)new File(this.eaLocation, moduleDirectory));
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)module));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (project == null) {
            return false;
        }
        return !EarProjectUtil.isJavaEEModule(project);
    }

    void store(WizardDescriptor wd) {
        HashMap<FileObject, ModuleType> userModules = new HashMap<FileObject, ModuleType>();
        block0: for (Vector<String> module : this.modules) {
            String description = module.get(1);
            for (ModuleType type : ModuleType.values()) {
                if (!type.getDescription().equals(description)) continue;
                File moduleDir = new File(this.eaLocation, module.get(0));
                FileObject moduleDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)moduleDir));
                assert (moduleDirFO != null);
                userModules.put(moduleDirFO, type);
                continue block0;
            }
        }
        wd.putProperty("userModules", userModules);
    }

    private DefaultTableModel getModuleTableModel() {
        return (DefaultTableModel)this.moduleTable.getModel();
    }

    private void addModuleToTable(File moduleF) {
        String relPath = PropertyUtils.relativizeFile((File)this.eaLocation, (File)moduleF);
        for (Vector<String> module : this.modules) {
            if (!relPath.equals(module.get(0))) continue;
            return;
        }
        Vector<String> row = new Vector<String>();
        row.add(relPath);
        row.add(this.getModuleType(relPath).getDescription());
        this.modules.add(row);
        this.changeSupport.fireChange();
    }

    private static final String getMessage(String bundleKey) {
        return NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)bundleKey);
    }

    private void initComponents() {
        this.appModulesLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleTable = new JTable();
        this.addModuleButton = new JButton();
        this.removeModuleButton = new JButton();
        this.appModulesLabel.setLabelFor(this.moduleTable);
        Mnemonics.setLocalizedText((JLabel)this.appModulesLabel, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_ApplicationModules"));
        this.moduleSP.setViewportView(this.moduleTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addModuleButton, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_Add"));
        this.addModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelModuleDetectionVisual.this.addModuleButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeModuleButton, (String)NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"LBL_IW_Remove"));
        this.removeModuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelModuleDetectionVisual.this.removeModuleButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.appModulesLabel).addComponent(this.moduleSP, -1, 296, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addModuleButton, -1, 90, Short.MAX_VALUE).addComponent(this.removeModuleButton))));
        layout.linkSize(0, this.addModuleButton, this.removeModuleButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.appModulesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addModuleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeModuleButton).addContainerGap()).addComponent(this.moduleSP, -1, 270, Short.MAX_VALUE))));
        this.appModulesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_ApplicationModules"));
        this.moduleSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSN_CTL_AppModules"));
        this.moduleSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_CTL_AppModules"));
        this.addModuleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_Add"));
        this.removeModuleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelModuleDetectionVisual.class, (String)"ACSD_LBL_IW_Remove"));
    }

    private void removeModuleButtonActionPerformed(ActionEvent evt) {
        int row = this.moduleTable.getSelectedRow();
        if (row != -1) {
            this.modules.remove(row);
            this.getModuleTableModel().fireTableRowsDeleted(row, row);
            this.changeSupport.fireChange();
        }
    }

    private void addModuleButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.eaLocation);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            if (this.eaLocation.equals(chooser.getSelectedFile())) {
                return;
            }
            this.addModuleToTable(chooser.getSelectedFile());
            this.getModuleTableModel().fireTableDataChanged();
        }
    }

    private ModuleType getModuleType(String relPath) {
        ModuleType type = null;
        File dir = FileUtil.normalizeFile((File)new File(this.eaLocation, relPath));
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO != null) {
            type = ModuleType.detectModuleType(dirFO);
        }
        return type == null ? ModuleType.WEB : type;
    }

    private class ModuleTypeEditor
    extends JComboBox
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected EventListenerList listenerList = new EventListenerList();
        protected ChangeEvent changeEvent = new ChangeEvent(this);

        ModuleTypeEditor() {
            for (ModuleType type : ModuleType.values()) {
                this.addItem(type.getDescription());
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ModuleTypeEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public void addCellEditorListener(CellEditorListener listener) {
            this.listenerList.add(CellEditorListener.class, listener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener listener) {
            this.listenerList.remove(CellEditorListener.class, listener);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i] != CellEditorListener.class) continue;
                CellEditorListener listener = (CellEditorListener)listeners[i + 1];
                listener.editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i] != CellEditorListener.class) continue;
                CellEditorListener listener = (CellEditorListener)listeners[i + 1];
                listener.editingCanceled(this.changeEvent);
            }
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String moduleType = (String)value;
            this.setSelectedItem(moduleType);
            return this;
        }
    }

    private static final class ModuleTypeRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        ModuleTypeRenderer() {
            for (ModuleType type : ModuleType.values()) {
                this.addItem(type.getDescription());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            String moduleType = (String)value;
            this.setSelectedItem(moduleType);
            return this;
        }
    }
}

