/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.owsm.OWSMPoliciesEditor;
import org.netbeans.modules.websvc.spi.wseditor.WSEditorProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class OWSMEditorProvider
implements WSEditorProvider {
    private static final String ORACLE = "oracle";
    private static Set<String> SECURITY_POLICIES = new LinkedHashSet<String>();

    public boolean enable(Node node) {
        JaxWsPoliciesSupport jaxWsPoliciesSupport;
        Service service = (Service)node.getLookup().lookup(Service.class);
        if (service == null && (jaxWsPoliciesSupport = (JaxWsService)node.getLookup().lookup(JaxWsService.class)) == null) {
            return false;
        }
        jaxWsPoliciesSupport = this.getPoliciesSupport(node.getLookup());
        if (jaxWsPoliciesSupport != null) {
            return this.getSecurityPolicies(jaxWsPoliciesSupport).size() != 0;
        }
        return false;
    }

    public WSEditor createWSEditor(Lookup lookup) {
        JaxWsPoliciesSupport jaxWsPoliciesSupport = this.getPoliciesSupport(lookup);
        return new OWSMPoliciesEditor(jaxWsPoliciesSupport, lookup, this.getSecurityPolicies(jaxWsPoliciesSupport));
    }

    private List<String> getSecurityPolicies(JaxWsPoliciesSupport jaxWsPoliciesSupport) {
        List list = jaxWsPoliciesSupport.getServicePolicyIds();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(SECURITY_POLICIES);
        linkedHashSet.retainAll(list);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : linkedHashSet) {
            arrayList.add(ORACLE + string);
        }
        return arrayList;
    }

    private JaxWsPoliciesSupport getPoliciesSupport(Lookup lookup) {
        Project project;
        J2eeModuleProvider j2eeModuleProvider;
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null && (j2eeModuleProvider = (J2eeModuleProvider)(project = FileOwnerQuery.getOwner((FileObject)fileObject)).getLookup().lookup(J2eeModuleProvider.class)) != null) {
            String string = j2eeModuleProvider.getServerInstanceID();
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                JaxWsPoliciesSupport jaxWsPoliciesSupport = JaxWsPoliciesSupport.getInstance((J2eePlatform)j2eePlatform);
                if (jaxWsPoliciesSupport != null && ORACLE.equals(jaxWsPoliciesSupport.getId())) {
                    return jaxWsPoliciesSupport;
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(OWSMEditorProvider.class.getName()).log(Level.INFO, null, instanceRemovedException);
            }
        }
        return null;
    }

    static {
        SECURITY_POLICIES.add("binding_authorization_denyall_policy");
        SECURITY_POLICIES.add("binding_authorization_permitall_policy");
        SECURITY_POLICIES.add("binding_permission_authorization_policy");
        SECURITY_POLICIES.add("no_authentication_service_policy");
        SECURITY_POLICIES.add("no_authorization_service_policy");
        SECURITY_POLICIES.add("no_messageprotection_service_policy");
        SECURITY_POLICIES.add("sts_trust_config_service_policy");
        SECURITY_POLICIES.add("whitelist_authorization_policy");
        SECURITY_POLICIES.add("wss_http_token_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_http_token_service_policy");
        SECURITY_POLICIES.add("wss_saml_or_username_token_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_saml_or_username_token_service_policy");
        SECURITY_POLICIES.add("wss_saml_token_bearer_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_saml_token_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_saml20_token_bearer_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_saml20_token_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_sts_issued_saml_bearer_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_username_token_over_ssl_service_policy");
        SECURITY_POLICIES.add("wss_username_token_service_policy");
        SECURITY_POLICIES.add("wss10_message_protection_service_policy");
        SECURITY_POLICIES.add("wss10_saml_hok_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss10_saml_token_service_policy");
        SECURITY_POLICIES.add("wss10_saml_token_with_message_integrity_service_policy");
        SECURITY_POLICIES.add("wss10_saml_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss10_saml_token_with_message_protection_ski_basic256_service_policy");
        SECURITY_POLICIES.add("wss10_saml20_token_service_policy");
        SECURITY_POLICIES.add("wss10_saml20_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss10_username_id_propagation_with_msg_protection_service_policy");
        SECURITY_POLICIES.add("wss10_username_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss10_username_token_with_message_protection_ski_basic256_service_policy");
        SECURITY_POLICIES.add("wss10_x509_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_kerberos_token_service_policy");
        SECURITY_POLICIES.add("wss11_kerberos_token_with_message_protection_basic128_service_policy");
        SECURITY_POLICIES.add("wss11_kerberos_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_saml_or_username_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_saml_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_saml20_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_sts_issued_saml_hok_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_username_token_with_message_protection_service_policy");
        SECURITY_POLICIES.add("wss11_x509_token_with_message_protection_service_policy");
    }
}

