/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.owsm.PoliciesVisualPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class OWSMPoliciesEditor
implements WSEditor {
    private static final String ORACLE = "oracle/";
    private JaxWsPoliciesSupport mySupport;
    private FileObject myFileObject;
    private PoliciesVisualPanel myPanel;
    private List<String> myPolicyIds;

    OWSMPoliciesEditor(JaxWsPoliciesSupport jaxWsPoliciesSupport, Lookup lookup, List<String> list) {
        this.mySupport = jaxWsPoliciesSupport;
        this.myFileObject = (FileObject)lookup.lookup(FileObject.class);
        this.myPolicyIds = list;
    }

    public JComponent createWSEditorComponent(Node node) throws InvalidDataException {
        if (this.mySupport == null || this.myFileObject == null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            jPanel.add(new JLabel(NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"ERR_NoPoliciesSupport")));
            return jPanel;
        }
        this.myPanel = new PoliciesVisualPanel(this.myPolicyIds, this.myFileObject);
        return this.myPanel;
    }

    public String getTitle() {
        return NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"TXT_OWSMEditorTitle");
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            PoliciesVisualPanel.JAVA_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    OWSMPoliciesEditor.this.doSave();
                }
            });
        } else {
            this.doSave();
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"TXT_PanelDescription");
    }

    private void doSave() {
        if (this.myPanel == null) {
            return;
        }
        if (this.myPanel.getWsFqn() == null) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.myFileObject);
        if (javaSource == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(OWSMPoliciesEditor.class, (String)"ERR_NoJava"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        final List<String> list = this.myPanel.getPolicyIds();
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy");
        if (list.size() > 1) {
            arrayList.add("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.myFileObject);
        this.mySupport.extendsProjectClasspath(project, arrayList);
        try {
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    String string = OWSMPoliciesEditor.this.myPanel.getWsFqn();
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    ClassTree classTree = null;
                    if (compilationUnitTree != null) {
                        List<? extends Tree> list2 = compilationUnitTree.getTypeDecls();
                        for (Tree tree : list2) {
                            Name name;
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                            ClassTree classTree2 = (ClassTree)tree;
                            Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(compilationUnitTree, classTree2));
                            if (!(element instanceof TypeElement) || !(name = ((TypeElement)element).getQualifiedName()).contentEquals(string)) continue;
                            classTree = classTree2;
                        }
                    }
                    if (classTree == null) {
                        return;
                    }
                    OWSMPoliciesEditor.this.rewriteAnnotations(list, workingCopy, classTree);
                }
            }).commit();
        }
        catch (IOException iOException) {
            Logger.getLogger(OWSMPoliciesEditor.class.getName()).log(Level.INFO, null, iOException);
        }
    }

    private void rewriteAnnotations(List<String> list, WorkingCopy workingCopy, ClassTree classTree) {
        Object object;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = classTree.getModifiers();
        List<? extends AnnotationTree> list2 = modifiersTree.getAnnotations();
        ArrayList<AnnotationTree> arrayList = new ArrayList<AnnotationTree>(list2.size());
        for (AnnotationTree object2 : list2) {
            object = object2.getAnnotationType();
            Element element = workingCopy.getTrees().getElement(workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), (Tree)object));
            if (((Object)element).equals(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies")) || ((Object)element).equals(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy"))) continue;
            arrayList.add(object2);
        }
        modifiersTree = treeMaker.Modifiers(modifiersTree, arrayList);
        Object object4 = null;
        if (list.size() > 1) {
            ArrayList<AnnotationTree> arrayList2 = new ArrayList<AnnotationTree>(list.size());
            for (String string : list) {
                AnnotationTree annotationTree = this.createPolicyAnnotation(treeMaker, string);
                arrayList2.add(annotationTree);
            }
            object = treeMaker.NewArray((Tree)workingCopy.getTrees().getTree(workingCopy.getElements().getTypeElement("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy")), Collections.emptyList(), arrayList2);
            object4 = treeMaker.Annotation((Tree)treeMaker.QualIdent("weblogic.wsee.jws.jaxws.owsm.SecurityPolicies"), Collections.singletonList(treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"value"), (ExpressionTree)object)));
        } else if (list.size() == 1) {
            object4 = this.createPolicyAnnotation(treeMaker, list.get(0));
        }
        if (object4 != null) {
            modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, object4);
        }
        workingCopy.rewrite((Tree)classTree.getModifiers(), (Tree)modifiersTree);
    }

    private AnnotationTree createPolicyAnnotation(TreeMaker treeMaker, String string) {
        AssignmentTree assignmentTree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"uri"), (ExpressionTree)treeMaker.Literal((Object)string));
        return treeMaker.Annotation((Tree)treeMaker.QualIdent("weblogic.wsee.jws.jaxws.owsm.SecurityPolicy"), Collections.singletonList(assignmentTree));
    }
}

