/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.apache.maven.cli.MavenCli;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.settings.Activation;
import org.netbeans.modules.maven.model.settings.Profile;
import org.netbeans.modules.maven.model.settings.Properties;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.maven.model.settings.SettingsQName;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RunIDEInstallationChecker
implements PrerequisitesChecker {
    public boolean checkRunConfig(RunConfig config) {
        NbMavenProject nbmp;
        Project project;
        if (config.getGoals().contains("nbm:run-ide") && (project = config.getProject()) != null && (nbmp = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class)) != null && MavenNbModuleImpl.findIDEInstallation(nbmp) == null) {
            String netbeansInstallation = new File(System.getProperty("netbeans.home")).getParent();
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.RunIDEInstallationChecker_message(netbeansInstallation, MavenCli.DEFAULT_USER_SETTINGS_FILE), Bundle.RunIDEInstallationChecker_title(), 2)) == NotifyDescriptor.OK_OPTION) {
                try {
                    RunIDEInstallationChecker.defineIDE(netbeansInstallation);
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
            return false;
        }
        return true;
    }

    private static void defineIDE(final String netbeansInstallation) throws IOException {
        FileObject settingsXml = FileUtil.toFileObject((File)MavenCli.DEFAULT_USER_SETTINGS_FILE);
        if (settingsXml == null) {
            settingsXml = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"Maven2Templates/settings.xml"), (FileObject)FileUtil.createFolder((File)MavenCli.DEFAULT_USER_SETTINGS_FILE.getParentFile()), (String)"settings");
        }
        Utilities.performSettingsModelOperations((FileObject)settingsXml, Collections.singletonList(new ModelOperation<SettingsModel>(){

            public void performOperation(SettingsModel model) {
                Profile netbeansIde = model.getSettings().findProfileById("netbeans-ide");
                if (netbeansIde != null) {
                    return;
                }
                netbeansIde = model.getFactory().createProfile();
                netbeansIde.setId("netbeans-ide");
                Activation activation = model.getFactory().createActivation();
                QName ACTIVE_BY_DEFAULT = SettingsQName.createQName((String)"activeByDefault", (boolean)true, (boolean)false);
                activation.setChildElementText("activeByDefault", "true", ACTIVE_BY_DEFAULT);
                netbeansIde.setActivation(activation);
                Properties properties = model.getFactory().createProperties();
                properties.setProperty("netbeans.installation", netbeansInstallation);
                netbeansIde.setProperties(properties);
                model.getSettings().addProfile(netbeansIde);
            }
        }));
    }
}

