/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

class LineTranslations {
    private static LineTranslations translations;
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new WeakHashMap<Object, Registry>();
    private Map<LineBreakpoint, BreakpointLineUpdater> lineUpdaters = new HashMap<LineBreakpoint, BreakpointLineUpdater>();
    private Map<Object, Map<LineBreakpoint, Integer>> originalBreakpointLines = new WeakHashMap<Object, Map<LineBreakpoint, Integer>>();
    private Map<Object, PropertyChangeListener> breakpointListeners = new WeakHashMap<Object, PropertyChangeListener>();

    private LineTranslations() {
    }

    static synchronized LineTranslations getTranslations() {
        if (translations == null) {
            translations = new LineTranslations();
        }
        return translations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTimeStamp(Object timeStamp) {
        Set modifiedDataObjects = DataObject.getRegistry().getModifiedSet();
        Registry r = new Registry();
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            this.timeStampToRegistry.put(timeStamp, r);
            for (DataObject dobj : modifiedDataObjects) {
                r.register(dobj);
            }
            if (this.changedFilesListener == null) {
                this.changedFilesListener = new ChangedFilesListener();
                DataObject.getRegistry().addChangeListener(this.changedFilesListener);
            }
        }
    }

    synchronized void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
        this.originalBreakpointLines.remove(timeStamp);
        this.breakpointListeners.remove(timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOriginalLineNumber(LineBreakpoint lb, final Object timeStamp) {
        PropertyChangeListener lineNumberListener;
        Map<LineBreakpoint, Integer> bpLines;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            bpLines = this.originalBreakpointLines.get(timeStamp);
            if (bpLines != null) {
                Integer line = bpLines.get(lb);
                if (line != null) {
                    return line;
                }
            } else {
                bpLines = new WeakHashMap<LineBreakpoint, Integer>();
                this.originalBreakpointLines.put(timeStamp, bpLines);
            }
        }
        int line = this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
        LineTranslations lineTranslations2 = this;
        synchronized (lineTranslations2) {
            bpLines.put(lb, line);
            lineNumberListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lineNumber".equals(evt.getPropertyName())) {
                        Map bpLines;
                        LineTranslations lineTranslations = LineTranslations.this;
                        synchronized (lineTranslations) {
                            bpLines = (Map)LineTranslations.this.originalBreakpointLines.get(timeStamp);
                            if (bpLines == null) {
                                return;
                            }
                        }
                        LineBreakpoint lb = (LineBreakpoint)evt.getSource();
                        int line = LineTranslations.this.getOriginalLineNumber(lb.getURL(), lb.getLineNumber(), timeStamp);
                        LineTranslations lineTranslations2 = LineTranslations.this;
                        synchronized (lineTranslations2) {
                            bpLines.put(lb, line);
                        }
                    }
                }
            };
            this.breakpointListeners.put(timeStamp, lineNumberListener);
        }
        lb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)lineNumberListener, (Object)lb));
        return line;
    }

    int getOriginalLineNumber(String url, int currentLineNumber, Object timeStamp) {
        if (timeStamp == null) {
            return currentLineNumber;
        }
        Line.Set lineSet = this.getLineSet(url, timeStamp);
        if (lineSet == null) {
            return currentLineNumber;
        }
        try {
            return lineSet.getOriginalLineNumber(lineSet.getCurrent(currentLineNumber));
        }
        catch (IndexOutOfBoundsException ioobex) {
            return currentLineNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTimeStamp(Object timeStamp, String url) {
        DataObject dobj = LineTranslations.getDataObject(url);
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            Registry registry = this.timeStampToRegistry.get(timeStamp);
            registry.register(dobj);
            Map<LineBreakpoint, Integer> bpLines = this.originalBreakpointLines.get(timeStamp);
            if (bpLines != null) {
                HashSet<LineBreakpoint> bpts = new HashSet<LineBreakpoint>(bpLines.keySet());
                for (LineBreakpoint bp : bpts) {
                    if (!url.equals(bp.getURL())) continue;
                    bpLines.remove(bp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set getLineSet(String url, Object timeStamp) {
        LineCookie lineCookie;
        DataObject dataObject = LineTranslations.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            LineTranslations lineTranslations = this;
            synchronized (lineTranslations) {
                Line.Set ls;
                Registry registry = this.timeStampToRegistry.get(timeStamp);
                if (registry != null && (ls = registry.getLineSet(dataObject)) != null) {
                    return ls;
                }
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    Line getLine(String url, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(url, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForLineUpdates(LineBreakpoint lb) {
        DataObject dobj = LineTranslations.getDataObject(lb.getURL());
        if (dobj != null) {
            BreakpointLineUpdater blu = new BreakpointLineUpdater(lb, dobj);
            try {
                blu.attach();
                LineTranslations lineTranslations = this;
                synchronized (lineTranslations) {
                    this.lineUpdaters.put(lb, blu);
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterFromLineUpdates(LineBreakpoint lb) {
        BreakpointLineUpdater blu;
        LineTranslations lineTranslations = this;
        synchronized (lineTranslations) {
            blu = this.lineUpdaters.remove(lb);
        }
        if (blu != null) {
            blu.detach();
        }
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private class BreakpointLineUpdater
    implements PropertyChangeListener {
        private final LineBreakpoint lb;
        private DataObject dataObject;
        private Line line;
        private boolean updatingLine = false;

        public BreakpointLineUpdater(LineBreakpoint lb, DataObject dataObject) {
            this.lb = lb;
            this.dataObject = dataObject;
        }

        public synchronized void attach() throws IOException {
            LineCookie lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.lb.addPropertyChangeListener((PropertyChangeListener)this);
            try {
                this.line = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                this.line.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public synchronized void detach() {
            this.lb.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.line != null) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(Line l) {
            try {
                int ln;
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = true;
                    ln = l.getLineNumber() + 1;
                }
                this.lb.setLineNumber(ln);
            }
            finally {
                BreakpointLineUpdater breakpointLineUpdater = this;
                synchronized (breakpointLineUpdater) {
                    this.updatingLine = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Line newLine;
            LineCookie lc;
            boolean ul;
            Line l;
            String propertyName = evt.getPropertyName();
            BreakpointLineUpdater breakpointLineUpdater = this;
            synchronized (breakpointLineUpdater) {
                l = this.line;
                ul = this.updatingLine;
            }
            if ("lineNumber".equals(propertyName) && l == evt.getSource()) {
                this.update(l);
                return;
            }
            if ("text".equals(propertyName) && l == evt.getSource()) {
                String text = l.getText();
                if (text.trim().length() == 0 && text.indexOf(10) >= 0) {
                    Line newLine2;
                    DataObject dobj2;
                    BreakpointLineUpdater breakpointLineUpdater2 = this;
                    synchronized (breakpointLineUpdater2) {
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                        if (this.dataObject == null) {
                            return;
                        }
                        dobj2 = this.dataObject;
                    }
                    LineCookie lc2 = (LineCookie)dobj2.getCookie(LineCookie.class);
                    try {
                        int lineNumber = l.getLineNumber();
                        int newLineNumber = lc2.getLineSet().getOriginal(lineNumber).getLineNumber();
                        for (int i = lineNumber + 1; i < newLineNumber; ++i) {
                            if (lc2.getLineSet().getCurrent(i).getText().trim().length() == 0) continue;
                            newLineNumber = i;
                            break;
                        }
                        newLine2 = lc2.getLineSet().getCurrent(newLineNumber);
                        newLine2.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        return;
                    }
                    BreakpointLineUpdater breakpointLineUpdater3 = this;
                    synchronized (breakpointLineUpdater3) {
                        this.line = newLine2;
                    }
                    this.update(newLine2);
                }
                return;
            }
            if (!ul && "lineNumber".equals(propertyName)) {
                DataObject dobj;
                BreakpointLineUpdater dobj2 = this;
                synchronized (dobj2) {
                    this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    if (this.dataObject == null) {
                        return;
                    }
                    dobj = this.dataObject;
                }
                try {
                    lc = (LineCookie)dobj.getCookie(LineCookie.class);
                    newLine = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    newLine.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IndexOutOfBoundsException ioobex) {
                    newLine = null;
                }
                BreakpointLineUpdater ioobex = this;
                synchronized (ioobex) {
                    this.line = newLine;
                }
            }
            if ("url".equals(propertyName)) {
                DataObject newDO = LineTranslations.getDataObject(this.lb.getURL());
                if (newDO != null) {
                    lc = (LineCookie)newDO.getCookie(LineCookie.class);
                    try {
                        newLine = lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                        newLine.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        newLine = null;
                    }
                } else {
                    newLine = null;
                }
                BreakpointLineUpdater breakpointLineUpdater4 = this;
                synchronized (breakpointLineUpdater4) {
                    if (this.line != null) {
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.dataObject = newDO;
                    this.line = newLine;
                }
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            LineTranslations lineTranslations = LineTranslations.this;
            synchronized (lineTranslations) {
                for (Registry r : LineTranslations.this.timeStampToRegistry.values()) {
                    for (DataObject dobj : newDOs) {
                        r.registerIfNotThere(dobj);
                    }
                }
            }
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        synchronized void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        synchronized void registerIfNotThere(DataObject dataObject) {
            if (!this.dataObjectToLineSet.containsKey(dataObject)) {
                this.register(dataObject);
            }
        }

        synchronized Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

