/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.debugger.jpda.projects.ViewModelListener;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;

public class ToolTipView
extends JComponent
implements HelpCtx.Provider {
    public static final String TOOLTIP_VIEW_NAME = "ToolTipView";
    private static volatile String expression;
    private static volatile ObjectVariable variable;
    private transient JComponent contentComponent;
    private transient ViewModelListener viewModelListener;
    private String name;

    private ToolTipView(String expression, ObjectVariable v, String icon) {
        ToolTipView.expression = expression;
        variable = v;
        this.name = TOOLTIP_VIEW_NAME;
        this.componentShowing(icon);
    }

    static String getExpression() {
        return expression;
    }

    static ObjectVariable getVariable() {
        return variable;
    }

    void setToolTipSupport(ToolTipSupport toolTipSupport) {
        if (this.viewModelListener != null) {
            this.viewModelListener.setToolTipSupport(toolTipSupport);
        }
    }

    private void componentShowing(String icon) {
        JComponent buttonsPane;
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.contentComponent == null) {
            this.setLayout(new BorderLayout());
            this.contentComponent = new JPanel(new BorderLayout());
            this.add((Component)this.contentComponent, "Center");
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.setBorderPainted(true);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
            toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.background")), BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getDefaults().getColor("Separator.foreground"))));
            toolBar.setPreferredSize(new Dimension(26, 10));
            this.add((Component)toolBar, "West");
            buttonsPane = toolBar;
        } else {
            buttonsPane = (JComponent)((BorderLayout)this.getLayout()).getLayoutComponent("West");
        }
        this.viewModelListener = new ViewModelListener(this.name, this.contentComponent, buttonsPane, null, ImageUtilities.loadImage((String)icon), variable);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        variable = null;
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerJPDAToolTipNode");
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.contentComponent == null) {
            return false;
        }
        return this.contentComponent.requestFocusInWindow();
    }

    public static synchronized ToolTipView getToolTipView(String expression, ObjectVariable v) {
        return new ToolTipView(expression, v, "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png");
    }

    static ExpandableTooltip createExpandableTooltip(String toolTipText) {
        return new ExpandableTooltip(toolTipText);
    }

    static class ExpandableTooltip
    extends JPanel {
        private static final String UI_PREFIX = "ToolTip";
        private JButton expButton;
        private boolean widthCheck = true;

        public ExpandableTooltip(String toolTipText) {
            Font font = UIManager.getFont("ToolTip.font");
            Color backColor = UIManager.getColor("ToolTip.background");
            Color foreColor = UIManager.getColor("ToolTip.foreground");
            if (font != null) {
                this.setFont(font);
            }
            if (foreColor != null) {
                this.setForeground(foreColor);
            }
            if (backColor != null) {
                this.setBackground(backColor);
            }
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
            this.setLayout(new BoxLayout(this, 0));
            Icon expIcon = UIManager.getIcon("Tree.collapsedIcon");
            this.expButton = new JButton(expIcon);
            this.expButton.setBorder(null);
            this.expButton.setBorderPainted(false);
            this.expButton.setContentAreaFilled(false);
            this.add(this.expButton);
            JLabel l = new JLabel(toolTipText);
            this.add(l);
        }

        void addExpansionListener(ActionListener treeExpansionListener) {
            this.expButton.addActionListener(treeExpansionListener);
        }

        void setWidthCheck(boolean widthCheck) {
            this.widthCheck = widthCheck;
        }

        @Override
        public void setSize(int width, int height) {
            Dimension prefSize = this.getPreferredSize();
            if (this.widthCheck) {
                if (width >= prefSize.width) {
                    width = prefSize.width;
                } else {
                    super.setSize(width, 10000);
                    prefSize = this.getPreferredSize();
                }
            }
            if (height >= prefSize.height) {
                height = prefSize.height;
            }
            super.setSize(width, height);
        }
    }
}

