/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.idebinding;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintsParser;
import org.netbeans.modules.java.hints.declarative.idebinding.ParserImpl;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HintsTask
extends ParserResultTask<Parser.Result> {
    public void run(final Parser.Result result, SchedulerEvent event) {
        final DeclarativeHintsParser.Result res = ParserImpl.getResult(result);
        final LinkedList<ErrorDescription> errors = new LinkedList<ErrorDescription>();
        if (res != null) {
            errors.addAll(res.errors);
            ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)result.getSnapshot().getSource().getFileObject());
            try {
                JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        for (DeclarativeHintsParser.HintTextDescription hd : res.hints) {
                            String code = ((Object)result.getSnapshot().getText().subSequence(hd.textStart, hd.textEnd)).toString();
                            LinkedList parsedErrors = new LinkedList();
                            Tree parsed = Utilities.parseAndAttribute((CompilationInfo)parameter, (String)code, null, parsedErrors);
                            for (Diagnostic d : parsedErrors) {
                                errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)d.getMessage(null), (FileObject)result.getSnapshot().getSource().getFileObject(), (int)((int)((long)hd.textStart + d.getStartPosition())), (int)((int)((long)hd.textStart + d.getEndPosition()))));
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        HintsController.setErrors((FileObject)result.getSnapshot().getSource().getFileObject(), (String)HintsTask.class.getName(), errors);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static final class FactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new HintsTask());
        }
    }
}

