/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.awt.Font;
import javax.swing.text.AttributeSet;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.highlighting.CompoundAttributes;
import org.netbeans.modules.editor.lib2.highlighting.HighlightItem;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public final class HighlightsList {
    private HighlightItem[] highlightItems;
    private int startIndex;
    private int endIndex;
    private int startOffset;

    public HighlightsList(int startOffset) {
        this.highlightItems = new HighlightItem[4];
        this.startOffset = startOffset;
    }

    public HighlightsList(int startOffset, HighlightItem[] items) {
        this.highlightItems = items;
        this.endIndex = items.length;
        this.startOffset = startOffset;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        int firstItemEndOffset;
        assert (startOffset < (firstItemEndOffset = this.highlightItems[this.startIndex].getEndOffset())) : "startOffset=" + startOffset + " >= firstItemEndOffset=" + firstItemEndOffset;
        this.startOffset = startOffset;
    }

    public int endOffset() {
        return this.endIndex - this.startIndex > 0 ? this.highlightItems[this.endIndex - 1].getEndOffset() : this.startOffset;
    }

    public int size() {
        return this.endIndex - this.startIndex;
    }

    public HighlightItem get(int index) {
        if (this.startIndex + index >= this.endIndex) {
            throw new IndexOutOfBoundsException("index=" + index + " >= size=" + this.size());
        }
        return this.highlightItems[this.startIndex + index];
    }

    public void add(HighlightItem item) {
        if (this.endIndex == this.highlightItems.length) {
            if (this.startIndex == 0) {
                HighlightItem[] tmp = new HighlightItem[this.highlightItems.length << 1];
                System.arraycopy(this.highlightItems, 0, tmp, 0, this.highlightItems.length);
                this.highlightItems = tmp;
            } else {
                System.arraycopy(this.highlightItems, this.startIndex, this.highlightItems, 0, this.size());
                this.endIndex -= this.startIndex;
                this.startIndex = 0;
            }
        }
        this.highlightItems[this.endIndex++] = item;
    }

    public AttributeSet cutSameFont(Font defaultFont, int maxEndOffset) {
        assert (maxEndOffset <= this.endOffset()) : "maxEndOffset=" + maxEndOffset + " > endOffset()=" + this.endOffset();
        HighlightItem item = this.highlightItems[this.startIndex];
        AttributeSet firstAttrs = item.getAttributes();
        int itemEndOffset = item.getEndOffset();
        if (maxEndOffset <= itemEndOffset) {
            if (maxEndOffset == itemEndOffset) {
                this.cutStartItems(1);
            }
            this.startOffset = maxEndOffset;
            return firstAttrs;
        }
        Font firstFont = ViewUtils.getFont(firstAttrs, defaultFont);
        int index = 1;
        while (true) {
            AttributeSet attrs;
            Font font;
            if (!(font = ViewUtils.getFont(attrs = (item = this.highlightItems[this.startIndex + index]).getAttributes(), defaultFont)).equals(firstFont)) {
                if (index == 1) {
                    this.cutStartItems(1);
                    this.startOffset = itemEndOffset;
                    return firstAttrs;
                }
                return this.cutCompound(index, itemEndOffset);
            }
            itemEndOffset = item.getEndOffset();
            if (maxEndOffset <= itemEndOffset) {
                if (maxEndOffset == itemEndOffset) {
                    return this.cutCompound(index + 1, itemEndOffset);
                }
                return this.cutCompoundNext(index, maxEndOffset, attrs);
            }
            ++index;
        }
    }

    public AttributeSet cut(int endOffset) {
        assert (endOffset <= this.endOffset()) : "endOffset=" + endOffset + " > endOffset()=" + this.endOffset();
        HighlightItem item = this.highlightItems[this.startIndex];
        AttributeSet attrs = item.getAttributes();
        int itemEndOffset = item.getEndOffset();
        if (endOffset <= itemEndOffset) {
            if (endOffset == itemEndOffset) {
                this.cutStartItems(1);
            }
            this.startOffset = endOffset;
            return attrs;
        }
        int index = 1;
        while (true) {
            if (endOffset <= (itemEndOffset = (item = this.highlightItems[this.startIndex + index]).getEndOffset())) {
                if (endOffset == itemEndOffset) {
                    return this.cutCompound(index + 1, itemEndOffset);
                }
                return this.cutCompoundNext(index, endOffset, item.getAttributes());
            }
            ++index;
        }
    }

    public AttributeSet cutSingleChar() {
        HighlightItem item = this.highlightItems[this.startIndex];
        ++this.startOffset;
        if (this.startOffset == item.getEndOffset()) {
            this.cutStartItems(1);
        }
        return item.getAttributes();
    }

    public void skip(int newStartOffset) {
        HighlightItem item = this.highlightItems[this.startIndex];
        int itemEndOffset = item.getEndOffset();
        if (newStartOffset <= itemEndOffset) {
            if (newStartOffset == itemEndOffset) {
                this.cutStartItems(1);
            }
        } else {
            int index = 1;
            while (true) {
                if (newStartOffset <= (itemEndOffset = (item = this.highlightItems[this.startIndex + index]).getEndOffset())) {
                    if (newStartOffset == itemEndOffset) {
                        this.cutStartItems(index + 1);
                        break;
                    }
                    this.cutStartItems(index);
                    break;
                }
                ++index;
            }
        }
        this.startOffset = newStartOffset;
    }

    private void cutStartItems(int count) {
        this.startIndex += count;
    }

    private CompoundAttributes cutCompound(int count, int lastItemEndOffset) {
        HighlightItem[] cutItems = new HighlightItem[count];
        System.arraycopy(this.highlightItems, this.startIndex, cutItems, 0, count);
        this.cutStartItems(count);
        CompoundAttributes cAttrs = new CompoundAttributes(this.startOffset, cutItems);
        this.startOffset = lastItemEndOffset;
        return cAttrs;
    }

    private CompoundAttributes cutCompoundNext(int count, int cutEndOffset, AttributeSet lastAttrs) {
        HighlightItem[] cutItems = new HighlightItem[count + 1];
        cutItems[count] = new HighlightItem(cutEndOffset, lastAttrs);
        System.arraycopy(this.highlightItems, this.startIndex, cutItems, 0, count);
        this.cutStartItems(count);
        CompoundAttributes cAttrs = new CompoundAttributes(this.startOffset, cutItems);
        this.startOffset = cutEndOffset;
        return cAttrs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        int size = this.size();
        int digitCount = ArrayUtilities.digitCount((int)size);
        int lastOffset = this.startOffset;
        for (int i = 0; i < size; ++i) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            HighlightItem item = this.get(i);
            sb.append(item.toString(lastOffset));
            sb.append('\n');
            lastOffset = item.getEndOffset();
        }
        return sb.toString();
    }
}

