/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class ViewStats {
    private static final Logger LOG = Logger.getLogger(ViewStats.class.getName());
    private static final int TEXT_LAYOUT_CREATED_THRESHOLD = 200;
    private static int textLayoutCreatedCount;
    private static int textLayoutCharCount;
    private static int initTextLayoutsCount;
    private static int staleViewCreationCount;

    private ViewStats() {
    }

    public static void incrementTextLayoutCreated(int charCount) {
        textLayoutCharCount += charCount;
        if (LOG.isLoggable(Level.FINE) && ++textLayoutCreatedCount % 200 == 0) {
            LOG.fine(ViewStats.stats());
        }
    }

    public static void incrementStaleViewCreations() {
        if (LOG.isLoggable(Level.FINE) && ++staleViewCreationCount % 10 == 0) {
            LOG.fine(ViewStats.stats());
        }
    }

    public static String stats() {
        return "TextLayouts:\n  created-count: " + textLayoutCreatedCount + "\n  char-count: " + textLayoutCharCount + "\nInitTextLayouts: " + initTextLayoutsCount + "\nStaleCreations: " + staleViewCreationCount + "\n";
    }
}

