/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.deviceanywhere;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPI;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIDeviceWrapper;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIGetLockedDevicesReturn;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIService;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DeviceChooser
extends JPanel {
    protected ChangeListener changeListener;
    private List<ApplicationAPIDeviceWrapper> devices;
    private JList deviceList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public DeviceChooser(String user, String password, ApplicationAPIDeviceWrapper selectedDevice) {
        this.initComponents();
        this.initView(user, password, selectedDevice);
    }

    private void initView(final String user, final String password, final ApplicationAPIDeviceWrapper selectedDevice) {
        this.deviceList.setSelectionMode(0);
        this.deviceList.setListData(this.getWarmupList());
        this.deviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (DeviceChooser.this.changeListener != null) {
                    DeviceChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.deviceList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && DeviceChooser.this.getSelectedDevice() != null && DeviceChooser.this.changeListener != null) {
                    DeviceChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationAPIService service = new ApplicationAPIService();
                    ApplicationAPI port = service.getApplicationAPI();
                    ApplicationAPIGetLockedDevicesReturn wrapper = port.getLockedDevices(user, password);
                    final int returnCode = wrapper.getReturnCode();
                    if (returnCode != 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String message = null;
                                if (returnCode == 1) {
                                    message = NbBundle.getMessage(DeviceChooser.class, (String)"MSG_InternalError");
                                } else if (returnCode == 2) {
                                    message = NbBundle.getMessage(DeviceChooser.class, (String)"MSG_BadLogin");
                                }
                                DeviceChooser.this.deviceList.setListData(new String[]{message});
                            }
                        });
                        return;
                    }
                    DeviceChooser.this.devices = wrapper.getDeviceWrappers().getDeviceWrappers();
                    if (DeviceChooser.this.devices.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeviceChooser.this.deviceList.setListData(new String[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_NoDevice")});
                            }
                        });
                        return;
                    }
                    final String[] result = new String[DeviceChooser.this.devices.size()];
                    int i = 0;
                    for (ApplicationAPIDeviceWrapper elem : DeviceChooser.this.devices) {
                        result[i++] = elem.getName();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DeviceChooser.this.deviceList.setListData(result);
                            if (selectedDevice != null) {
                                DeviceChooser.this.deviceList.setSelectedValue(selectedDevice.getName(), true);
                            } else {
                                DeviceChooser.this.deviceList.setSelectedIndex(0);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DeviceChooser.this.deviceList.setListData(new String[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_ConnectionError")});
                        }
                    });
                    if (ex instanceof ClassNotFoundException) {
                        ErrorManager.getDefault().notify(256, (Throwable)ex);
                    }
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.deviceList = new JList();
        this.jLabel1.setLabelFor(this.deviceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DeviceChooser.class, (String)"LBL_AvailableDevices"));
        this.jScrollPane1.setViewportView(this.deviceList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 362, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 149, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DeviceChooser.class, (String)"ACSN_AvailableDevices"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeviceChooser.class, (String)"ACSD_AvailableDevices"));
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(DeviceChooser.class, (String)"MSG_LoadingDevices")};
    }

    public ApplicationAPIDeviceWrapper getSelectedDevice() {
        if (this.isValidDeviceName(this.deviceList.getSelectedValue())) {
            return this.devices.get(this.deviceList.getSelectedIndex());
        }
        return null;
    }

    public List<ApplicationAPIDeviceWrapper> getLockedDevices() {
        return this.devices;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    private boolean isValidDeviceName(Object object) {
        return this.devices != null && !this.devices.isEmpty();
    }
}

