/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NbInputHandler
implements InputHandler {
    private JComboBox combo = null;
    private JTextField input = null;
    private final Runnable interestingOutputCallback;
    boolean secure;
    private static String defaultValue;

    public NbInputHandler(Runnable interestingOutputCallback) {
        this.interestingOutputCallback = interestingOutputCallback;
    }

    public void handleInput(InputRequest request) throws BuildException {
        this.interestingOutputCallback.run();
        this.combo = null;
        this.input = null;
        JPanel panel = this.createPanel(request);
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, NbBundle.getMessage(NbInputHandler.class, (String)"TITLE_input_handler"));
        do {
            DialogDisplayer.getDefault().createDialog(dlg).setVisible(true);
            if (dlg.getValue() != NotifyDescriptor.OK_OPTION) {
                throw new BuildException(NbBundle.getMessage(NbInputHandler.class, (String)"MSG_input_aborted"));
            }
            String value = this.combo != null ? (String)this.combo.getSelectedItem() : this.input.getText();
            request.setInput(value);
        } while (!request.isInputValid());
    }

    private JPanel createPanel(InputRequest request) {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        String promptText = request.getPrompt().trim();
        JLabel prompt = new JLabel();
        if (promptText.contains("\n")) {
            prompt.setText("<html>" + promptText.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\r?\n", "<br>"));
        } else {
            prompt.setText(promptText);
        }
        if (promptText.length() > 0) {
            prompt.setDisplayedMnemonic(promptText.charAt(0));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 6);
        pane.add((Component)prompt, gridBagConstraints);
        JComponent comp = null;
        if (request instanceof MultipleChoiceInputRequest) {
            this.combo = new JComboBox(((MultipleChoiceInputRequest)request).getChoices());
            if (defaultValue != null && defaultValue.length() > 0) {
                this.combo.setSelectedItem(NbInputHandler.getDefaultValue(request));
            }
            comp = this.combo;
        } else {
            this.input = this.secure ? new JPasswordField(NbInputHandler.getDefaultValue(request), 25) : new JTextField(NbInputHandler.getDefaultValue(request), 25);
            comp = this.input;
        }
        prompt.setLabelFor(comp);
        comp.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbInputHandler.class, (String)"ACSD_input_handler"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 11, 6);
        pane.add((Component)comp, gridBagConstraints);
        pane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbInputHandler.class, (String)"TITLE_input_handler"));
        pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbInputHandler.class, (String)"ACSD_input_handler"));
        HelpCtx.setHelpIDString((JComponent)pane, (String)"org.apache.tools.ant.module.run.NBInputHandler");
        return pane;
    }

    static void setDefaultValue(String d) {
        defaultValue = d;
    }

    private static String getDefaultValue(InputRequest req) {
        try {
            return (String)InputRequest.class.getMethod("getDefaultValue", new Class[0]).invoke((Object)req, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return defaultValue;
    }
}

