/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TriggeredTakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class TriggeredTakeSnapshotProfilingPoint
extends TriggeredGlobalProfilingPoint
implements PropertyChangeListener {
    private static final String NO_DATA_AVAILABLE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataAvailableMsg");
    private static final String NO_DATA_REMOTE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataRemoteMsg");
    private static final String NO_DATA_JDK_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataJdkMsg");
    private static final String ONE_HIT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderProjectString");
    private static final String HEADER_MODE_DATA_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderModeDataString");
    private static final String HEADER_MODE_DUMP_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderModeDumpString");
    private static final String HEADER_TARGET_PROJECT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTargetProjectString");
    private static final String HEADER_TARGET_CUSTOM_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTargetCustomString");
    private static final String HEADER_RESET_RESULTS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderResetResultsString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderHitsString");
    private static final String OPEN_SNAPSHOT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_OpenSnapshotString");
    private static final String USED_HEAP_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_UsedHeapResultString");
    private static final String HEAP_USAGE_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeapUsageResultString");
    private static final String SURVGEN_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_SurvGenResultString");
    private static final String LOADED_CLASSES_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_LoadedClassesResultString");
    private static final String HIT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HitString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_SnapshotNotAvailableMsg");
    private static final String DATA_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_DataString");
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TriggeredTakeSnapshotProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean resetResults) {
        if (this.resetResults == resetResults) {
            return;
        }
        this.resetResults = resetResults;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String snapshotFile) {
        if (snapshotFile == null || !new File(snapshotFile).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(snapshotFile))) {
            return;
        }
        String oldSnapshotFile = this.snapshotFile;
        this.snapshotFile = snapshotFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, oldSnapshotFile, snapshotFile);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String snapshotTarget) {
        if (!snapshotTarget.equals(TARGET_PROJECT_KEY) && !snapshotTarget.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + snapshotTarget);
        }
        if (this.snapshotTarget.equals(snapshotTarget)) {
            return;
        }
        String oldSnapshotTarget = this.snapshotTarget;
        this.snapshotTarget = snapshotTarget;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, oldSnapshotTarget, snapshotTarget);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String snapshotType) {
        if (snapshotType == null || !snapshotType.equals(TYPE_PROFDATA_KEY) && !snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + snapshotType);
        }
        if (this.snapshotType.equals(snapshotType)) {
            return;
        }
        String oldSnapshotType = this.snapshotType;
        this.snapshotType = snapshotType;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, oldSnapshotType, snapshotType);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TriggeredTakeSnapshotProfilingPoint.this.hasReport()) {
                    TriggeredTakeSnapshotProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasReport()) {
            if (evt.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport();
        topComponent.open();
        topComponent.requestActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int size = this.results.size();
                String string = size == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, size, Utils.formatLocalProfilingPointTime(this.results.get(size - 1).getTimestamp()));
                return string;
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        TriggeredTakeSnapshotCustomizer customizer = (TriggeredTakeSnapshotCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        customizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        customizer.setPPFile(this.getSnapshotFile());
        customizer.setPPResetResults(this.getResetResults());
        customizer.setTriggerCondition(this.getCondition());
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return ProjectStorage.getSettingsFolder((Lookup.Provider)this.getProject(), (boolean)true);
        }
        File f = new File(this.snapshotFile);
        f.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        TriggeredTakeSnapshotCustomizer customizer = (TriggeredTakeSnapshotCustomizer)c;
        this.setName(customizer.getPPName());
        this.setSnapshotType(customizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(customizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(customizer.getPPFile());
        this.setResetResults(customizer.getPPResetResults());
        this.setCondition(customizer.getTriggerCondition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(long hitValue) {
        String snapshotFilename;
        long currentTime = System.currentTimeMillis();
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            snapshotFilename = this.takeHeapdumpHit();
        } else {
            snapshotFilename = this.takeSnapshotHit();
            if (this.getResetResults()) {
                try {
                    ResultsManager.getDefault().reset();
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.targetJVMIsAlive()) {
                        runner.resetTimers();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        }
        Object object = this.resultsSync;
        synchronized (object) {
            this.results.add(new Result(currentTime, hitValue, snapshotFilename));
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.hasResults();
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private String getCurrentHeapDumpFilename() {
        try {
            String fileName = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject folder = this.getSnapshotDirectory();
            return FileUtil.toFile((FileObject)folder).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)"hprof") + "." + "hprof";
        }
        catch (IOException e) {
            return null;
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private String takeHeapdumpHit() {
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        if (runner.getProfilingSessionStatus().remoteProfiling) {
            return NO_DATA_REMOTE_MSG;
        }
        if (!runner.hasSupportedJDKForHeapDump()) {
            return NO_DATA_JDK_MSG;
        }
        String dumpFileName = this.getCurrentHeapDumpFilename();
        if (dumpFileName == null) {
            return NO_DATA_AVAILABLE_MSG;
        }
        boolean heapdumpTaken = false;
        try {
            heapdumpTaken = runner.getProfilerClient().takeHeapDump(dumpFileName);
        }
        catch (Exception ex) {
            ProfilerLogger.log((Exception)ex);
        }
        if (heapdumpTaken) {
            ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            try {
                return new File(dumpFileName).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException ex) {
                ProfilerLogger.log((Exception)ex);
                return NO_DATA_AVAILABLE_MSG;
            }
        }
        return NO_DATA_AVAILABLE_MSG;
    }

    private static LoadedSnapshot takeSnapshot() {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String snapshotFilename = null;
        loadedSnapshot = TriggeredTakeSnapshotProfilingPoint.takeSnapshot();
        if (loadedSnapshot != null) {
            try {
                FileObject snapshotDirectory = this.getSnapshotDirectory();
                FileObject profFile = snapshotDirectory.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, profFile);
                snapshotFilename = FileUtil.toFile((FileObject)profFile).toURI().toURL().toExternalForm();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return snapshotFilename == null ? NO_DATA_AVAILABLE_MSG : snapshotFilename;
    }

    private static class Result {
        private final String resultString;
        private final long hitValue;
        private final long timestamp;

        public Result(long timestamp, long hitValue, String resultString) {
            this.timestamp = timestamp;
            this.hitValue = hitValue;
            this.resultString = resultString;
        }

        public long getHitValue() {
            return this.hitValue;
        }

        public String getResultString() {
            return this.resultString;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMode());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderTarget());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderResetResults());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = TriggeredTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (!TriggeredTakeSnapshotProfilingPoint.this.hasResults()) {
                    dataAreaTextBuilder.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    for (int i = 0; i < TriggeredTakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(TriggeredTakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TriggeredTakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = TriggeredTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TriggeredTakeSnapshotProfilingPoint.this.results.get(index);
                String resultString = result.getResultString();
                String snapshotInformation = resultString.startsWith(TriggeredTakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + resultString + "'>" + OPEN_SNAPSHOT_STRING + "</a>" : resultString;
                String hitValueInformation = "";
                if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 2) {
                    hitValueInformation = MessageFormat.format(USED_HEAP_RESULT_STRING, Float.valueOf((float)result.getHitValue() / 1048576.0f));
                } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 1) {
                    hitValueInformation = MessageFormat.format(HEAP_USAGE_RESULT_STRING, result.getHitValue());
                } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 3) {
                    hitValueInformation = MessageFormat.format(SURVGEN_RESULT_STRING, result.getHitValue());
                } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 4) {
                    hitValueInformation = MessageFormat.format(LOADED_CLASSES_RESULT_STRING, result.getHitValue());
                }
                return MessageFormat.format(HIT_STRING, index + 1, Utils.formatLocalProfilingPointTime(result.getTimestamp()), snapshotInformation, hitValueInformation);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, TriggeredTakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TriggeredTakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, TriggeredTakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderMode() {
            return TriggeredTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TriggeredTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? HEADER_MODE_DATA_STRING : HEADER_MODE_DUMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + TriggeredTakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtilities.getDisplayName((Lookup.Provider)TriggeredTakeSnapshotProfilingPoint.this.getProject()));
        }

        private String getHeaderResetResults() {
            return MessageFormat.format(HEADER_RESET_RESULTS_STRING, TriggeredTakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TriggeredTakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TriggeredTakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? HEADER_TARGET_PROJECT_STRING : MessageFormat.format(HEADER_TARGET_PROJECT_STRING, TriggeredTakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, TriggeredTakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea();
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    File resolvedFile = null;
                    try {
                        resolvedFile = new File(url.toURI());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    File snapshotFile = resolvedFile;
                    if (snapshotFile != null && snapshotFile.exists()) {
                        String type = TriggeredTakeSnapshotProfilingPoint.this.getSnapshotType();
                        if (type.equals(TriggeredTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) || type.equals(TriggeredTakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            ResultsManager.getDefault().openSnapshot(snapshotFile);
                        }
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SNAPSHOT_NOT_AVAILABLE_MSG, 2));
                    }
                }
            };
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(DATA_STRING);
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }
}

