/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TimeCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private static final String UNITS_MINUTES = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_UnitsMinutes");
    private static final String UNITS_HOURS = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_UnitsHours");
    private static final String TAKE_AT_LABEL_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeAtLabelText");
    private static final String NOW_BUTTON_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_NowButtonText");
    private static final String TODAY_BUTTON_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TodayButtonText");
    private static final String TAKE_ONCE_RADIO_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeOnceRadioText");
    private static final String TAKE_EVERY_RADIO_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeEveryRadioText");
    private static final String TIME_FIELD_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TimeFieldAccessName");
    private static final String DATE_FIELD_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_DateFieldAccessName");
    private static final String FREQUENCY_COMBO_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_FrequencyComboAccessName");
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance();
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance();
    private static int defaultTextComponentHeight = -1;
    private Color TEXT_FOREGROUND;
    private JButton timeTakeAtButton;
    private JButton timeTakeAtDateButton;
    private JComboBox timeFrequencyCombo;
    private JLabel timeTakeAtLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton timeFrequencyRadio;
    private JRadioButton timeOnceRadio;
    private JSpinner timeFrequencySpinner;
    private JTextField timeTakeAtDateField;
    private JTextField timeTakeAtField;

    public TimeCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTimeCondition(TimedGlobalProfilingPoint.TimeCondition condition) {
        this.timeTakeAtField.setText(TIME_FORMAT.format(new Date(condition.getStartTime())));
        this.timeTakeAtDateField.setText(DATE_FORMAT.format(new Date(condition.getStartTime())));
        this.timeOnceRadio.setSelected(!condition.getRepeats());
        this.timeFrequencyRadio.setSelected(condition.getRepeats());
        this.timeFrequencySpinner.setValue(condition.getPeriodTime());
        switch (condition.getPeriodUnits()) {
            case 1: {
                this.timeFrequencyCombo.setSelectedItem(UNITS_MINUTES);
                break;
            }
            case 2: {
                this.timeFrequencyCombo.setSelectedItem(UNITS_HOURS);
                break;
            }
        }
    }

    public TimedGlobalProfilingPoint.TimeCondition getTimeCondition() {
        TimedGlobalProfilingPoint.TimeCondition condition = new TimedGlobalProfilingPoint.TimeCondition();
        Date time = null;
        try {
            time = TIME_FORMAT.parse(this.timeTakeAtField.getText());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        Date date = null;
        try {
            date = DATE_FORMAT.parse(this.timeTakeAtDateField.getText());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (time == null || date == null) {
            return null;
        }
        condition.setStartTime(time.getTime() + date.getTime() + (long)Calendar.getInstance().get(15));
        condition.setRepeats(this.timeFrequencyRadio.isSelected());
        condition.setPeriodTime((Integer)this.timeFrequencySpinner.getValue());
        if (this.timeFrequencyCombo.getSelectedItem() == UNITS_MINUTES) {
            condition.setPeriodUnits(1);
        } else if (this.timeFrequencyCombo.getSelectedItem() == UNITS_HOURS) {
            condition.setPeriodUnits(2);
        }
        return condition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timeTakeAtButton) {
            this.timeTakeAtField.setText(TIME_FORMAT.format(new Date(System.currentTimeMillis())));
        } else if (e.getSource() == this.timeTakeAtDateButton) {
            this.timeTakeAtDateField.setText(DATE_FORMAT.format(new Date(System.currentTimeMillis())));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        TimeCustomizer main = new TimeCustomizer();
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.timeFrequencyRadio) {
            this.timeFrequencySpinner.setEnabled(this.timeFrequencyRadio.isSelected());
            this.timeFrequencyCombo.setEnabled(this.timeFrequencyRadio.isSelected());
        }
    }

    private boolean checkDate() {
        try {
            Date date = DATE_FORMAT.parse(this.timeTakeAtDateField.getText());
            this.timeTakeAtDateField.setForeground(this.TEXT_FOREGROUND);
            return true;
        }
        catch (ParseException ex) {
            this.timeTakeAtDateField.setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkTime() {
        try {
            Date time = TIME_FORMAT.parse(this.timeTakeAtField.getText());
            this.timeTakeAtField.setForeground(this.TEXT_FOREGROUND);
            return true;
        }
        catch (ParseException ex) {
            this.timeTakeAtField.setForeground(Color.RED);
            return false;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel timeSettingsContainer = new JPanel(new GridBagLayout());
        this.timeTakeAtLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.timeTakeAtLabel, (String)TAKE_AT_LABEL_TEXT);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        timeSettingsContainer.add((Component)this.timeTakeAtLabel, constraints);
        this.timeTakeAtField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeTakeAtField.getAccessibleContext().setAccessibleName(TIME_FIELD_ACCESS_NAME);
        this.timeTakeAtLabel.setLabelFor(this.timeTakeAtField);
        this.timeTakeAtField.getDocument().addDocumentListener(this);
        this.timeTakeAtField.setHorizontalAlignment(11);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        timeSettingsContainer.add((Component)this.timeTakeAtField, constraints);
        this.timeTakeAtButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeTakeAtButton, (String)NOW_BUTTON_TEXT);
        this.timeTakeAtButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 8);
        timeSettingsContainer.add((Component)this.timeTakeAtButton, constraints);
        this.timeTakeAtDateField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeTakeAtDateField.getAccessibleContext().setAccessibleName(DATE_FIELD_ACCESS_NAME);
        this.timeTakeAtDateField.getDocument().addDocumentListener(this);
        this.timeTakeAtDateField.setHorizontalAlignment(11);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        timeSettingsContainer.add((Component)this.timeTakeAtDateField, constraints);
        this.timeTakeAtDateButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeTakeAtDateButton, (String)TODAY_BUTTON_TEXT);
        this.timeTakeAtDateButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        timeSettingsContainer.add((Component)this.timeTakeAtDateButton, constraints);
        JPanel triggerFillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        timeSettingsContainer.add((Component)triggerFillerPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)timeSettingsContainer, constraints);
        ButtonGroup triggerRadiosGroup = new ButtonGroup();
        JPanel triggerRadiosContainer = new JPanel(new GridBagLayout());
        this.timeOnceRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeOnceRadio, (String)TAKE_ONCE_RADIO_TEXT);
        triggerRadiosGroup.add(this.timeOnceRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerRadiosContainer.add((Component)this.timeOnceRadio, constraints);
        this.timeFrequencyRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeFrequencyRadio, (String)TAKE_EVERY_RADIO_TEXT);
        triggerRadiosGroup.add(this.timeFrequencyRadio);
        this.timeFrequencyRadio.setSelected(true);
        this.timeFrequencyRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerRadiosContainer.add((Component)this.timeFrequencyRadio, constraints);
        this.timeFrequencySpinner = new JExtendedSpinner(new SpinnerNumberModel(1, 1, 9999, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), 3.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerRadiosContainer.add((Component)this.timeFrequencySpinner, constraints);
        this.timeFrequencyCombo = new JComboBox(new Object[]{UNITS_MINUTES, UNITS_HOURS}){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Math.min(super.getPreferredSize().width, 200), super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeFrequencyCombo.getAccessibleContext().setAccessibleName(FREQUENCY_COMBO_ACCESS_NAME);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)this.timeFrequencyCombo, constraints);
        JPanel takeRadiosSpacer = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)takeRadiosSpacer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)triggerRadiosContainer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
        this.TEXT_FOREGROUND = this.timeTakeAtDateField.getForeground();
    }

    private void updateValidity() {
        boolean isValid;
        boolean isTimeValid = this.checkTime();
        boolean isDateValid = this.checkDate();
        boolean bl = isValid = isTimeValid && isDateValid;
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

