/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.StatusProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class TaskListBridge
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public TaskListBridge() {
        super(NbBundle.getMessage(TaskListBridge.class, (String)"LBL_TaskList_DisplayName"), NbBundle.getMessage(TaskListBridge.class, (String)"LBL_TaskList_Desc"), null);
    }

    public List<? extends Task> scan(FileObject resource) {
        Project prj;
        if ("text/x-maven-pom+xml".equals(resource.getMIMEType()) && "pom.xml".equals(resource.getNameExt()) && (prj = FileOwnerQuery.getOwner((FileObject)resource)) != null && prj.getLookup().lookup(NbMavenProject.class) != null) {
            ModelSource ms = Utilities.createModelSource((FileObject)resource);
            POMModel model = POMModelFactory.getDefault().getModel(ms);
            model.setAutoSyncActive(false);
            List<ErrorDescription> errs = StatusProvider.StatusProviderImpl.findHints(model, prj, -1, -1);
            ArrayList<Task> tasks = new ArrayList<Task>();
            for (ErrorDescription error : errs) {
                try {
                    Task task = Task.create((FileObject)resource, (String)TaskListBridge.severityToTaskListString(error.getSeverity()), (String)error.getDescription(), (int)(error.getRange().getBegin().getLine() + 1));
                    tasks.add(task);
                }
                catch (IOException e) {
                    Logger.getLogger(TaskListBridge.class.getName()).log(Level.INFO, "Error while converting errors to tasklist", e);
                }
            }
            return tasks;
        }
        return Collections.emptyList();
    }

    public void attach(FileTaskScanner.Callback callback) {
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }
}

